/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.comm;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.console.connection.JRockitServerException;
import com.jrockit.console.connection.RmpConnection;
import com.jrockit.console.connection.RmpPushHandler;
import com.jrockit.memleak.comm.Controller;
import com.jrockit.memleak.comm.MemLeakControllerException;
import java.util.StringTokenizer;

public class ControllerRMP
implements Controller {
    public static final String PROTOCOL = "RMP";
    public static final int DEFAULT_PORT = 7090;
    private static final int SUPPORTED_PROTOCOL_VERSION = 2;
    private String m_hostName;
    private int m_port;

    public ControllerRMP(String hostName, int port, String userName, String password) {
        this.m_hostName = hostName;
        this.m_port = port != 0 ? port : 7090;
    }

    private RmpConnection getServerConnection() throws MemLeakControllerException {
        try {
            return new RmpConnection(this.m_hostName, this.m_port, (RmpPushHandler)new DummyPushHandler(), RmpConnection.IGNORING_ERROR_HANDLER);
        }
        catch (JRockitConnectionException jrce) {
            throw new MemLeakControllerException(jrce);
        }
    }

    private String connectAndInvoke(String command, String params, String query) throws MemLeakControllerException {
        RmpConnection connection = null;
        try {
            connection = this.getServerConnection();
            this.checkRequiredProtocolVersion(connection);
            boolean status = command == null || !(params == null ? !connection.sendCommand(command) : !connection.sendCommand(command, params));
            String string = status && query != null ? connection.sendQuery(query) : null;
            return string;
        }
        catch (MemLeakControllerException mce) {
            throw mce;
        }
        catch (JRockitServerException jrse) {
            throw new MemLeakControllerException(jrse);
        }
        catch (JRockitConnectionException jrce) {
            throw new MemLeakControllerException(jrce, 1);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public int startMLS() throws MemLeakControllerException {
        return this.startMLS(0);
    }

    public int startMLS(int port) throws MemLeakControllerException {
        String argument = "2#" + port;
        String portString = this.connectAndInvoke(null, null, "SMEM" + argument);
        ControllerRMP.checkForException(portString);
        if (portString != null) {
            try {
                return Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new MemLeakControllerException("Start MLS returned a non integer value! (This shouldn't happen - please contact support.)");
            }
        }
        return 0;
    }

    private static void checkForException(String response) throws MemLeakControllerException {
        if (response == null || !response.startsWith("class ")) {
            return;
        }
        int colonPos = response.indexOf(58);
        if (colonPos < 0) {
            return;
        }
        String exName = response.substring(6, colonPos);
        String msg = response.substring(colonPos + 1);
        int kind = 3;
        if (exName.equals("java.lang.IllegalAccessException")) {
            kind = 2;
        }
        throw new MemLeakControllerException(msg, kind);
    }

    public void shutDownMLS() throws MemLeakControllerException {
        this.connectAndInvoke("EMEM", null, null);
    }

    public int getMLSPort() throws MemLeakControllerException {
        String portString = this.connectAndInvoke(null, null, "MPOR");
        if (portString != null) {
            try {
                return Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new MemLeakControllerException("getMLSPort() returned a non integer value! (This shouldn't happen - please contact support.)");
            }
        }
        return 0;
    }

    private int[] parseCSV(String commaSepVersions) throws MemLeakControllerException {
        StringTokenizer st = new StringTokenizer(commaSepVersions, "{,}");
        int[] portArray = new int[st.countTokens()];
        int i = 0;
        try {
            while (st.hasMoreElements()) {
                portArray[i++] = Integer.parseInt(st.nextToken());
            }
        }
        catch (NumberFormatException e) {
            throw new MemLeakControllerException("getAvailableProtocolVersions() returned a non integer value! (This shouldn't happen - please contact support.)");
        }
        return portArray;
    }

    public int[] getAvailableProtocolVersions() throws MemLeakControllerException {
        String verString = this.connectAndInvoke(null, null, "MVER");
        return verString != null ? this.parseCSV(verString) : new int[]{};
    }

    public void printAvailableProtocolVersions() throws MemLeakControllerException {
        Object connection = null;
        try {
            int[] versions;
            System.out.print("Available versions: ");
            int[] nArray = versions = this.getAvailableProtocolVersions();
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                int version = nArray[n2];
                System.out.print(String.valueOf(version) + " ");
                ++n2;
            }
            System.out.println("");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void checkRequiredProtocolVersion(RmpConnection connection) throws MemLeakControllerException, JRockitConnectionException, JRockitServerException {
        String verString = connection.sendQuery("MVER");
        if (verString != null) {
            int[] versions;
            int[] nArray = versions = this.parseCSV(verString);
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                int version = nArray[n2];
                if (version == 2) {
                    return;
                }
                ++n2;
            }
            verString = verString.substring(1, verString.length() - 1);
        }
        throw new MemLeakControllerException("Server does not support the protocol version required by the client: 2.\nSever supports the following version(s): " + verString + ".\n" + "Make sure you are running a supported version of the JVM.", 1);
    }

    private static class DummyPushHandler
    implements RmpPushHandler {
        private DummyPushHandler() {
        }

        public void dispatch(long subscriptionID, long timestamp, String aspectRmpName, String aspectValue) {
        }
    }
}

