/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak.comm;

import com.jrockit.memleak.comm.Controller;
import com.jrockit.memleak.comm.MemLeakControllerException;
import com.jrockit.memleak.mlp.MlpUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.naming.CommunicationException;

public class ControllerRJMX
implements Controller {
    public static final String PROTOCOL = "RJMX";
    public static final int DEFAULT_PORT = 7091;
    private static final String KEY_CREDENTIALS = "jmx.remote.credentials";
    private String OPERATION_START = null;
    private String OPERATION_STOP = null;
    private String ATTRIBUTE_PORT = null;
    private String ATTRIBUTE_VERSIONS = null;
    private static final String[] START_SIGNATURE;
    private static final int SUPPORTED_PROTOCOL_VERSION = 2;
    private Object CONSOLE_MBEAN_OBJECT_NAME;
    private static Class CLS_MBeanServerConnection;
    private static Class CLS_ObjectName;
    private static Class CLS_JMXConnector;
    private static Class CLS_JMXConnectorFactory;
    private static Class CLS_JMXServiceURL;
    private static Class CLS_AttributeNotFoundException;
    private static Class CLS_MBeanException;
    private static Method MBeanSC_invoke;
    private static Method MBeanSC_getAttribute;
    private static Method JMXCF_newJMXConnector;
    private static Method JMXC_connect;
    private static Method JMXC_close;
    private static Method JMXC_getMBeanServerConnection;
    private static Constructor JMXSURL_new;
    private static Constructor ObjName_new;
    private String m_hostName;
    private String m_password;
    private String m_userName;
    private int m_port;

    static {
        String[] startSignature = new String[]{"int", "int"};
        START_SIGNATURE = startSignature;
        try {
            CLS_MBeanServerConnection = Class.forName("javax.management.MBeanServerConnection");
            CLS_ObjectName = Class.forName("javax.management.ObjectName");
            CLS_JMXConnector = Class.forName("javax.management.remote.JMXConnector");
            CLS_JMXConnectorFactory = Class.forName("javax.management.remote.JMXConnectorFactory");
            CLS_JMXServiceURL = Class.forName("javax.management.remote.JMXServiceURL");
            CLS_AttributeNotFoundException = Class.forName("javax.management.AttributeNotFoundException");
            CLS_MBeanException = Class.forName("javax.management.MBeanException");
            MBeanSC_invoke = CLS_MBeanServerConnection.getMethod("invoke", CLS_ObjectName, String.class, Object[].class, String[].class);
            MBeanSC_getAttribute = CLS_MBeanServerConnection.getMethod("getAttribute", CLS_ObjectName, String.class);
            JMXCF_newJMXConnector = CLS_JMXConnectorFactory.getMethod("newJMXConnector", CLS_JMXServiceURL, Map.class);
            JMXC_connect = CLS_JMXConnector.getMethod("connect", null);
            JMXC_close = CLS_JMXConnector.getMethod("close", null);
            JMXC_getMBeanServerConnection = CLS_JMXConnector.getMethod("getMBeanServerConnection", null);
            JMXSURL_new = CLS_JMXServiceURL.getConstructor(String.class, String.class, Integer.TYPE, String.class);
            ObjName_new = CLS_ObjectName.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Required RJMX classes not found.");
        }
    }

    public ControllerRJMX(String hostName, int port, String userName, String password) {
        this.m_hostName = hostName;
        this.m_userName = userName;
        this.m_password = password;
        this.m_port = port != 0 ? port : 7091;
    }

    private Object getServerConnection() throws Exception {
        HashMap<String, String[]> map = null;
        if (this.m_userName != null || this.m_password != null) {
            map = new HashMap<String, String[]>();
            String[] credentials = new String[]{this.m_userName, this.m_password};
            map.put(KEY_CREDENTIALS, credentials);
        }
        Object jmxc = JMXCF_newJMXConnector.invoke(null, ControllerRJMX.createConnectionURL(this.m_hostName, this.m_port), map);
        JMXC_connect.invoke(jmxc, null);
        return jmxc;
    }

    private static Object createConnectionURL(String hostName, int port) throws Exception {
        return JMXSURL_new.newInstance("rmi", "", new Integer(0), "/jndi/rmi://" + hostName + ":" + port + "/jmxrmi");
    }

    private static Object createObjectName(String name) throws Exception {
        return ObjName_new.newInstance(name);
    }

    private static Object getMBeanServerConnection(Object jmxc) throws Exception {
        return JMXC_getMBeanServerConnection.invoke(jmxc, null);
    }

    private Object connectAndInvoke(Method method, ParamConstructor pconstruct) throws MemLeakControllerException {
        Object jmxc = null;
        try {
            jmxc = this.getServerConnection();
            Object mBeanServConn = ControllerRJMX.getMBeanServerConnection(jmxc);
            Method m = CLS_MBeanServerConnection.getMethod("getAttribute", CLS_ObjectName, String.class);
            String version = this.onlyInvoke(mBeanServConn, m, new Object[]{ControllerRJMX.createObjectName("java.lang:type=Runtime"), "VmVersion"}).toString();
            if (version.substring(1, 4).equals("26.")) {
                this.ATTRIBUTE_PORT = "MLSPort";
                this.OPERATION_STOP = "shutDownMLS";
                this.OPERATION_START = "startMLS";
                this.ATTRIBUTE_VERSIONS = "MLSVersions";
                this.CONSOLE_MBEAN_OBJECT_NAME = ControllerRJMX.createObjectName("com.jrockit:type=JRockitConsole");
            } else {
                this.ATTRIBUTE_PORT = "ServerPort";
                this.OPERATION_STOP = "shutDownServer";
                this.OPERATION_START = "startServer";
                this.ATTRIBUTE_VERSIONS = "ProtocolVersions";
                this.CONSOLE_MBEAN_OBJECT_NAME = this.tryLoadingJRockitSpecificMBeans(mBeanServConn);
            }
            this.checkRequiredProtocolVersion(mBeanServConn);
            Object object = method.invoke(mBeanServConn, pconstruct.createParams());
            return object;
        }
        catch (MemLeakControllerException mce) {
            throw mce;
        }
        catch (Exception e) {
            Throwable cause = e;
            int kind = 0;
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
            }
            if (cause instanceof CommunicationException || CLS_AttributeNotFoundException.isInstance(cause)) {
                kind = 1;
            } else if (CLS_MBeanException.isInstance(cause)) {
                if ((cause = cause.getCause()) instanceof IllegalAccessException) {
                    kind = 2;
                } else if (cause instanceof Exception) {
                    kind = 3;
                }
            }
            throw new MemLeakControllerException(cause, kind);
        }
        finally {
            try {
                if (jmxc != null) {
                    JMXC_close.invoke(jmxc, null);
                }
            }
            catch (Exception e) {
                MlpUtil.log(e);
            }
        }
    }

    private Object onlyInvoke(Object mBeanServConn, Method method, Object[] params) throws Exception {
        return method.invoke(mBeanServConn, params);
    }

    private Object tryLoadingJRockitSpecificMBeans(Object connection) throws MemLeakControllerException {
        try {
            Object objName = ControllerRJMX.createObjectName("bea.jrockit.management:type=MemLeak");
            try {
                this.tryLoading(connection, objName, "bea.jrockit.management.JRockitConsole");
            }
            catch (Exception e) {
                objName = ControllerRJMX.createObjectName("oracle.jrockit.management:type=MemLeak");
                this.tryLoading(connection, objName, "oracle.jrockit.management.JRockitConsole");
            }
            return objName;
        }
        catch (Exception e) {
            throw new MemLeakControllerException(e, 1, "Could not create the console MBean. You're probably running against a Sun JVM.");
        }
    }

    private void tryLoading(Object connection, Object objName, String className) throws ClassNotFoundException, NoSuchMethodException, Exception {
        try {
            Method mbeanInfoMethod = CLS_MBeanServerConnection.getMethod("getMBeanInfo", objName.getClass());
            this.onlyInvoke(connection, mbeanInfoMethod, new Object[]{objName});
        }
        catch (Exception e1) {
            if (e1 instanceof InvocationTargetException && e1.getCause() != null && Class.forName("javax.management.InstanceNotFoundException").isAssignableFrom(e1.getCause().getClass())) {
                Method createMBeanMethod = CLS_MBeanServerConnection.getMethod("createMBean", String.class, objName.getClass());
                Object[] objectArray = new Object[2];
                objectArray[0] = className;
                this.onlyInvoke(connection, createMBeanMethod, objectArray);
            }
            throw e1;
        }
    }

    public int startMLS() throws MemLeakControllerException {
        return this.startMLS(0);
    }

    public int startMLS(final int port) throws MemLeakControllerException {
        Object actualPort = this.connectAndInvoke(MBeanSC_invoke, new ParamConstructor(){

            public Object[] createParams() {
                return new Object[]{ControllerRJMX.this.CONSOLE_MBEAN_OBJECT_NAME, ControllerRJMX.this.OPERATION_START, new Object[]{new Integer(2), new Integer(port)}, START_SIGNATURE};
            }
        });
        if (actualPort instanceof Integer) {
            return (Integer)actualPort;
        }
        throw new MemLeakControllerException("Start MLS returned a non integer value! (This shouldn't happen - please contact support.)");
    }

    public void shutDownMLS() throws MemLeakControllerException {
        this.connectAndInvoke(MBeanSC_invoke, new ParamConstructor(){

            public Object[] createParams() {
                Object[] objectArray = new Object[4];
                objectArray[0] = ControllerRJMX.this.CONSOLE_MBEAN_OBJECT_NAME;
                objectArray[1] = ControllerRJMX.this.OPERATION_STOP;
                return objectArray;
            }
        });
    }

    public int getMLSPort() throws MemLeakControllerException {
        Object mlsPort = this.connectAndInvoke(MBeanSC_getAttribute, new ParamConstructor(){

            public Object[] createParams() {
                return new Object[]{ControllerRJMX.this.CONSOLE_MBEAN_OBJECT_NAME, ControllerRJMX.this.ATTRIBUTE_PORT};
            }
        });
        if (mlsPort instanceof Integer) {
            return (Integer)mlsPort;
        }
        throw new MemLeakControllerException("getMLSPort() returned a non integer value! (This shouldn't happen - please contact support.)");
    }

    public void printAvailableProtocolVersions() throws MemLeakControllerException {
        Object val = this.connectAndInvoke(MBeanSC_getAttribute, new ParamConstructor(){

            public Object[] createParams() {
                return new Object[]{ControllerRJMX.this.CONSOLE_MBEAN_OBJECT_NAME, ControllerRJMX.this.ATTRIBUTE_VERSIONS};
            }
        });
        if (val instanceof int[]) {
            int[] versions;
            System.out.print("Available versions: ");
            int[] nArray = versions = (int[])val;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                int version = nArray[n2];
                System.out.print(String.valueOf(version) + " ");
                ++n2;
            }
            System.out.println();
        }
    }

    private int[] getAvailableProtocolVersions(Object mBeanServConn) throws Exception {
        Object val = MBeanSC_getAttribute.invoke(mBeanServConn, this.CONSOLE_MBEAN_OBJECT_NAME, this.ATTRIBUTE_VERSIONS);
        if (val instanceof int[]) {
            return (int[])val;
        }
        return new int[0];
    }

    private void checkRequiredProtocolVersion(Object mBeanServConn) throws Exception {
        boolean found = false;
        int[] versions = this.getAvailableProtocolVersions(mBeanServConn);
        StringBuffer supportedVersions = new StringBuffer();
        int[] nArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            int version = nArray[n2];
            if (version == 2) {
                found = true;
                break;
            }
            if (supportedVersions.length() != 0) {
                supportedVersions.append(", ");
            }
            supportedVersions.append(version);
            ++n2;
        }
        if (!found) {
            throw new MemLeakControllerException("Server does not support the protocol version required by the client: 2.\nSever supports the following version(s): " + supportedVersions + ".\n" + "Make sure you are running a supported version of the JVM.");
        }
    }

    static interface ParamConstructor {
        public Object[] createParams();
    }
}

