/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.memleak;

import com.jrockit.memleak.AllocTraceCallback;
import com.jrockit.memleak.DisconnectCallback;
import com.jrockit.memleak.Feature;
import com.jrockit.memleak.IArraySizeInfo;
import com.jrockit.memleak.IClassInfo;
import com.jrockit.memleak.IClassRef;
import com.jrockit.memleak.IFieldValue;
import com.jrockit.memleak.IHeapHistogram;
import com.jrockit.memleak.IInstanceReferrers;
import com.jrockit.memleak.IMemleakValueFactory;
import com.jrockit.memleak.IObjectInfo;
import com.jrockit.memleak.IObjectSpecifier;
import com.jrockit.memleak.IPointToTypeInfo;
import com.jrockit.memleak.IRelationshipInfo;
import com.jrockit.memleak.ITruncatable;
import com.jrockit.memleak.ITypeHeapInfo;
import com.jrockit.memleak.ITypeSpecifier;
import com.jrockit.memleak.IValue;
import com.jrockit.memleak.MemLeakServerException;
import com.jrockit.memleak.NotAnArrayException;
import com.jrockit.memleak.TrendAnalysisCallback;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IMemLeak {
    public static final int UNLIMITED_DEPTH = -1;
    public static final int UNLIMITED_INSTANCES = -1;
    public static final long UNLIMITED_SIZE = -1L;
    public static final int FOREVER = -1;
    public static final long ONLY_CACHED = -1L;
    public static final long SOMETHING = 0L;
    public static final long NOTHING_CACHED = Long.MAX_VALUE;
    public static final int OBJECT_ID_INVALID = -1;
    public static final int OBJECT_ID_NULL = -2;
    public static final String META_KNOWN_KEYS = "KNOWN_KEYS";
    public static final String META_SHORT_PROTOCOL_NAME = "SHORT_PROTOCOL_NAME";
    public static final String META_SERVER_PORT = "SERVER_PORT";
    public static final String META_READ_BYTES = "READ_BYTES";
    public static final String META_IGNORED_REPLY_BYTES = "IGNORED_REPLY_BYTES";

    public void setFactory(IMemleakValueFactory var1);

    public Object getMetaData(Object var1);

    public Set<Feature> getFeatures();

    public boolean hasFeatures(Feature ... var1);

    public void setTrendAnalysisCallback(TrendAnalysisCallback var1) throws IOException;

    public void setTrendAnalysisEnabled(boolean var1) throws IOException, IllegalStateException, MemLeakServerException;

    public boolean isTrendAnalysisEnabled() throws IOException, MemLeakServerException;

    public IHeapHistogram getHeapHistogram() throws IOException, MemLeakServerException;

    public void setHistogramCutoff(double var1) throws IllegalArgumentException;

    public double getHistogramCutoff();

    public IPointToTypeInfo[] getTypesPointingTo(String var1, long var2) throws IOException, MemLeakServerException;

    public IPointToTypeInfo[] getTypesPointingTo(ITypeSpecifier var1, long var2) throws IOException, MemLeakServerException;

    public ITruncatable<IArraySizeInfo> getLargestArrays(String var1) throws IOException, MemLeakServerException, NotAnArrayException;

    public ITruncatable<IArraySizeInfo> getLargestArrays(ITypeSpecifier var1) throws IOException, MemLeakServerException, NotAnArrayException;

    public IInstanceReferrers getInstancesPointingTo(IObjectSpecifier var1, long var2) throws IOException, MemLeakServerException;

    public ITruncatable<IInstanceReferrers> getPathPointingTo(IObjectSpecifier var1, int var2, int var3) throws IOException, MemLeakServerException;

    public ITruncatable<IRelationshipInfo> getInstanceRelationships(String var1, String var2, int var3, long var4, int var6) throws IOException, MemLeakServerException;

    public ITruncatable<IRelationshipInfo> getInstanceRelationships(ITypeSpecifier var1, ITypeSpecifier var2, int var3, long var4, int var6) throws IOException, MemLeakServerException;

    public long getKeepAliveSizeOf(IObjectSpecifier var1, long var2, long var4) throws IOException, MemLeakServerException;

    public IFieldValue[] getFieldValues(IObjectSpecifier var1, long var2) throws IOException, IllegalArgumentException, MemLeakServerException;

    public IFieldValue[] getStaticFields(IClassRef var1) throws IOException, IllegalArgumentException, MemLeakServerException;

    public int getArrayLength(IObjectSpecifier var1) throws IOException, IllegalArgumentException, MemLeakServerException;

    public IValue[] getArrayData(IObjectSpecifier var1, int var2, int var3) throws IOException, IllegalArgumentException, MemLeakServerException;

    public void enableAllocTracesForClass(String var1, int var2, int var3, AllocTraceCallback var4) throws IOException, IllegalStateException, MemLeakServerException;

    public void enableAllocTracesForClass(ITypeSpecifier var1, int var2, int var3, AllocTraceCallback var4) throws IOException, IllegalStateException, MemLeakServerException;

    public void pollAllocationTraces() throws IOException, IllegalStateException, MemLeakServerException;

    public boolean isAllocTracesEnabled() throws IOException, MemLeakServerException;

    public void disableAllocTraces() throws IOException, MemLeakServerException;

    public void setAllocTraceFrequency(int var1) throws IOException, MemLeakServerException;

    public int getAllocTraceFrequency() throws IOException, MemLeakServerException;

    public void doFullGC() throws IOException, MemLeakServerException;

    public void deleteObjectId(IObjectSpecifier var1) throws IOException, MemLeakServerException;

    public void deleteObjectId(int var1) throws IOException, MemLeakServerException;

    public void deleteObjectIds(int ... var1) throws IOException, MemLeakServerException;

    public void deleteAllObjectIds() throws IOException, MemLeakServerException;

    public void destroy() throws IOException;

    public void setDisconnectCallback(DisconnectCallback var1);

    public boolean isConnected();

    public IObjectInfo getObjectInfo(IObjectSpecifier var1) throws IOException, MemLeakServerException;

    public IClassInfo getClassInfo(IClassRef var1) throws IOException, MemLeakServerException;

    public IClassRef[] getClasses(String var1, long var2) throws IOException, MemLeakServerException;

    public IClassRef[] getClasses(ITypeSpecifier var1, long var2) throws IOException, MemLeakServerException;

    public ITruncatable<IObjectInfo> getInstances(IClassRef var1, int var2) throws IOException, MemLeakServerException;

    public ITypeHeapInfo<IClassInfo> getLastTypeHeapInfo(IClassInfo var1, long var2);

    public ITypeHeapInfo<?> getLastTypeHeapInfo(String var1, long var2);
}

