/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.wizards;

import com.jrockit.mc.core.misc.ui.FileSelector;
import com.jrockit.mc.core.wizards.Messages;
import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SimpleImportFromFileWizardPage
extends WizardPage {
    private final String DIALOG_SETTINGS_NAME = "simple.import.settings";
    private final String m_fileExtension;
    private IDialogSettings m_importSettings;
    private FileSelector m_fsc;

    public SimpleImportFromFileWizardPage(String pageName, String fileExtension) {
        super(pageName);
        this.m_fileExtension = fileExtension;
    }

    private void initialize() {
        this.m_importSettings = this.getDialogSettings().getSection("simple.import.settings");
        if (this.m_importSettings == null) {
            this.m_importSettings = this.getDialogSettings().addNewSection("simple.import.settings");
        }
    }

    public void createControl(Composite parent) {
        this.initialize();
        GridLayout layout = new GridLayout();
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        this.m_fsc = new FileSelector(control, this.m_importSettings, Messages.SimpleImportFromFileWizardPage_IMPORT_FROM_FILE_TEXT, true, 4096);
        this.m_fsc.setFileExtension(this.m_fileExtension);
        this.m_fsc.setLayoutData(gd);
        this.m_fsc.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("file.does.not.exist".equals(event.getProperty())) {
                    SimpleImportFromFileWizardPage.this.setErrorMessage((String)event.getNewValue());
                    SimpleImportFromFileWizardPage.this.setMessage(null);
                    SimpleImportFromFileWizardPage.this.setPageComplete(false);
                }
                if ("no.file.specified".equals(event.getProperty())) {
                    SimpleImportFromFileWizardPage.this.setMessage((String)event.getNewValue());
                    SimpleImportFromFileWizardPage.this.setErrorMessage(null);
                    SimpleImportFromFileWizardPage.this.setPageComplete(false);
                }
                if ("valid.file.name.specified".equals(event.getProperty())) {
                    SimpleImportFromFileWizardPage.this.setMessage(Messages.SimpleImportFromFileWizardPage_MESSAGE_CLICK_FINISH_TO_START_IMPORT);
                    SimpleImportFromFileWizardPage.this.setErrorMessage(null);
                    SimpleImportFromFileWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.setControl((Control)control);
        this.setPageComplete(this.m_fsc.getFile() != null);
    }

    public File getFile() {
        if (this.m_fsc != null && !this.m_fsc.isDisposed()) {
            return this.m_fsc.getFile();
        }
        return null;
    }

    public void storeFilename() {
        this.m_fsc.storeFilename();
    }
}

