/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.wizards;

import com.jrockit.mc.core.misc.ui.FileSelector;
import com.jrockit.mc.core.wizards.Messages;
import com.jrockit.mc.core.wizards.TreeContentProviderWizardPage;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public abstract class ExportToFileWizardPage
extends TreeContentProviderWizardPage {
    private final String DIALOG_SETTINGS_NAME = "export.to.file.wizard.settings";
    private final String OVERWRITE_OK = "overwrite.earning.check";
    private final String m_fileExtension;
    private IDialogSettings m_exportSettings;
    private FileSelector m_fileSelector;

    public ExportToFileWizardPage(String pageName, String fileExtension) {
        super(pageName);
        this.m_fileExtension = fileExtension;
    }

    protected void initialize() {
        this.m_exportSettings = this.getDialogSettings().getSection("export.to.file.wizard.settings");
        if (this.m_exportSettings == null) {
            this.m_exportSettings = this.getDialogSettings().addNewSection("export.to.file.wizard.settings");
        }
    }

    public boolean isExportToFileOk() {
        if (!this.isOverwriteOK() && this.getFile() != null && this.getFile().exists()) {
            MessageBox m = new MessageBox(this.getShell(), 200);
            m.setMessage(MessageFormat.format(Messages.ExportToFileWizardPage_OVERWRITE_QUESTION_TEXT, "" + this.getFile()));
            m.setText(Messages.ExportToFileWizardPage_OVERWRITE_QUESTION_TITLE);
            if (m.open() == 128) {
                return false;
            }
        }
        return true;
    }

    protected Control createBottomContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridData fileSectionGridData = new GridData(4, 4, true, false);
        this.m_fileSelector = new FileSelector(container, this.m_exportSettings, Messages.ExportToFileWizardPage_EXPORT_TO_FILE, false, 8192);
        this.m_fileSelector.setFileExtension(this.m_fileExtension);
        this.m_fileSelector.setLayoutData(fileSectionGridData);
        this.m_fileSelector.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("no.file.specified".equals(event.getProperty())) {
                    ExportToFileWizardPage.this.setMessage((String)event.getNewValue());
                    ExportToFileWizardPage.this.setErrorMessage(null);
                    ExportToFileWizardPage.this.setPageComplete(false);
                }
                if ("valid.file.name.specified".equals(event.getProperty())) {
                    ExportToFileWizardPage.this.setMessage(Messages.ExportToFileWizardPage_CLICK_FINISH_MESSAGE_TEXT);
                    ExportToFileWizardPage.this.setErrorMessage(null);
                    ExportToFileWizardPage.this.updatePageComplete();
                    ExportToFileWizardPage.this.setPageComplete(ExportToFileWizardPage.this.isPageComplete());
                }
            }
        });
        GridData overWriteCheckGridData = new GridData(4, 4, true, false);
        Control overWriteontrol = this.createOvewriteWarningCheckbox(container);
        overWriteontrol.setLayoutData((Object)overWriteCheckGridData);
        return container;
    }

    private Control createOvewriteWarningCheckbox(Composite container) {
        final Button button = new Button(container, 32);
        button.setText(Messages.ExportToFileWizardPage_WARN_IF_OVERWRITE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!button.isDisposed()) {
                    ExportToFileWizardPage.this.setOverwriteOK(!button.getSelection());
                }
            }
        });
        button.setSelection(!this.m_exportSettings.getBoolean("overwrite.earning.check"));
        return button;
    }

    public boolean isOverwriteOK() {
        return this.m_exportSettings.getBoolean("overwrite.earning.check");
    }

    protected void setOverwriteOK(boolean overwrite) {
        this.m_exportSettings.put("overwrite.earning.check", overwrite);
    }

    public boolean isPageComplete() {
        return this.isValidFaile() && super.isPageComplete();
    }

    private boolean isValidFaile() {
        return this.getFile() != null && this.getFile().toString().trim().length() != 0;
    }

    public File getFile() {
        File file;
        if (this.m_fileSelector != null && !this.m_fileSelector.isDisposed() && (file = this.m_fileSelector.getFile()) != null) {
            return ExportToFileWizardPage.ensureFileExtension(file, this.m_fileExtension);
        }
        return null;
    }

    public void storeFilename() {
        this.m_fileSelector.storeFilename();
    }

    private static File ensureFileExtension(File file, String fileExtension) {
        String path;
        if (fileExtension != null && fileExtension.length() > 0 && (path = file.getPath()) != null && !path.endsWith("." + fileExtension)) {
            path = String.valueOf(path) + "." + fileExtension;
            new File(path);
        }
        return file;
    }
}

