/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.views;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.handlers.FieldViewerContributionFactory;
import com.jrockit.mc.core.handlers.MCContextMenuManager;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.site.HandlerActivator;
import com.jrockit.mc.core.site.MenuFactoryActivator;
import com.jrockit.mc.core.ui.MCLayoutFactory;
import com.jrockit.mc.core.ui.fields.FieldTableEditAction;
import com.jrockit.mc.core.ui.fields.FieldToolkit;
import com.jrockit.mc.core.views.ViewerPart;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class FieldViewerPart
extends ViewerPart {
    private final IDialogSettings m_settings;
    private final Field[] m_fields;
    private MenuManager m_menuManager;

    public FieldViewerPart(Field[] fieldPrototypes, String viewerIdentifier, IDialogSettings settings) {
        super(viewerIdentifier);
        this.m_settings = settings;
        this.m_fields = this.createFieldInstances(fieldPrototypes);
    }

    protected Field[] createFieldInstances(Field[] fieldPrototypes) {
        return FieldToolkit.instantiateFieldArray(fieldPrototypes);
    }

    protected final IDialogSettings getSettings() {
        return this.m_settings;
    }

    protected final Field[] getFields() {
        return this.m_fields;
    }

    protected final Composite createViewerClient(Composite parent) {
        this.loadDialogSettings(this.getSettings());
        Composite container = new Composite(parent, 0);
        container.setLayout(MCLayoutFactory.createMarginFreeFormPageLayout());
        this.loadDialogSettings(this.getSettings());
        Control top = this.createTop(container);
        if (top != null) {
            GridData gd1 = new GridData(4, 4, true, false);
            top.setLayoutData((Object)gd1);
        }
        this.m_viewer = this.createViewer(container);
        GridData gd2 = new GridData(4, 4, true, true);
        this.m_viewer.getControl().setLayoutData((Object)gd2);
        this.setupFieldMenu();
        this.setupContextMenu();
        return (Composite)this.m_viewer.getControl();
    }

    protected Control createTop(Composite container) {
        return null;
    }

    protected void setupFieldMenu() {
        this.setupSelectionProvider();
        this.registerFieldFactoryContributions();
        this.initializeToolbar();
    }

    protected void registerFieldFactoryContributions() {
        FieldViewerContributionFactory fvcf = new FieldViewerContributionFactory(this.getFields(), (IWorkbenchPartSite)this.getViewSite(), this.getSectionIdentifier());
        Collection commands = fvcf.createCommands();
        Collection handlers = fvcf.createHandlers();
        if (commands.size() == handlers.size()) {
            Iterator itC = commands.iterator();
            Iterator itH = handlers.iterator();
            while (itH.hasNext() && itC.hasNext()) {
                Command command = (Command)itC.next();
                IHandler handler = (IHandler)itH.next();
                if (command == null || handler == null) continue;
                this.getMCSite().registerActivator(new HandlerActivator(command.getId(), handler));
            }
            this.getMCSite().registerActivator(new MenuFactoryActivator(fvcf));
        } else {
            CorePlugin.getDefault().getLogger().severe("The naumber of handlers dosen't match the number of commands. The context menu will not be complete for" + this.getSectionIdentifier());
        }
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        IDialogSettings tableSettings = settings.getSection(this.getSectionIdentifier());
        if (tableSettings == null) {
            tableSettings = settings.addNewSection(this.getSectionIdentifier());
        }
        FieldToolkit.fillDialogSettingsFromFields(this.getFields(), tableSettings);
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        IDialogSettings tableSettings = settings.getSection(this.getSectionIdentifier());
        if (tableSettings != null) {
            FieldToolkit.fillFieldsFromDialogSettings(tableSettings, this.getFields());
        }
    }

    protected void setupContextMenu() {
        MenuManager menuManager = this.getMenuManager();
        if (menuManager != null) {
            Control control = this.getViewer().getControl();
            Menu menu = menuManager.createContextMenu(control);
            control.setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
        }
    }

    public void dispose() {
        super.dispose();
        this.saveDialogSettings(this.getSettings());
        Field[] fields = this.getFields();
        if (fields != null) {
            int n = 0;
            while (n < fields.length) {
                fields[n].dispose();
                ++n;
            }
        }
    }

    private void initializeToolbar() {
        IActionBars bars = this.getViewSite().getActionBars();
        FieldTableEditAction ftea = new FieldTableEditAction(this.getSettings());
        ftea.setFields(this.getFields());
        bars.getToolBarManager().add((IAction)ftea);
        bars.getMenuManager().add((IAction)ftea);
    }

    protected MenuManager getMenuManager() {
        if (this.m_menuManager == null) {
            this.m_menuManager = new MCContextMenuManager(this.getSectionIdentifier());
        }
        return this.m_menuManager;
    }
}

