/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldBackgroundPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Event;

public abstract class ShadedFieldBackgroundPainter
extends FieldBackgroundPainter {
    public ShadedFieldBackgroundPainter(Field[] fields) {
        this(fields, 0.0, 0);
    }

    public ShadedFieldBackgroundPainter(Field[] fields, double percentage, int margin) {
        super(fields, percentage, margin);
    }

    protected void drawPattern(Event event, int patternStart, int patternEnd, int drawStart, int drawWidth, MCColor fromColor, MCColor toColor) {
        GC gc = event.gc;
        PatternResources resources = new PatternResources();
        try {
            gc.setBackgroundPattern(resources.createPattern(event, patternStart, patternEnd, fromColor, toColor));
            gc.fillRectangle(event.x + drawStart, event.y, drawWidth, event.getBounds().height);
        }
        finally {
            resources.dispose();
        }
    }

    private static class PatternResources {
        private Color m_fromColor;
        private Color m_toColor;
        private Pattern m_pattern;

        private PatternResources() {
        }

        public Pattern createPattern(Event event, int start, int end, MCColor fromColor, MCColor toColor) {
            this.m_fromColor = this.createColor(event, fromColor);
            this.m_toColor = this.createColor(event, toColor);
            this.m_pattern = this.createPattern(event, start, end);
            return this.m_pattern;
        }

        private Color createColor(Event event, MCColor mcColor) {
            return mcColor.createSWTColor((Device)event.display);
        }

        private Pattern createPattern(Event event, int start, int end) {
            return new Pattern((Device)event.display, (float)(event.x + start), 0.0f, (float)(event.x + end), 0.0f, this.m_fromColor, this.m_toColor);
        }

        public void dispose() {
            this.disposeResource((Resource)this.m_fromColor);
            this.disposeResource((Resource)this.m_toColor);
            this.disposeResource((Resource)this.m_pattern);
        }

        private void disposeResource(Resource resource) {
            if (resource != null) {
                resource.dispose();
            }
        }
    }
}

