/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.model.fields.IStructuredRowSelection;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.model.fields.StructuredRowSelection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class SelectionAdapter
implements ISelectionProvider {
    private final ListenerList m_listeners = new ListenerList();
    private final ISelectionChangedListener m_changeListener = this.createPushSelectionListener();
    private final ISelectionProvider m_provider;

    public SelectionAdapter(ISelectionProvider selectionProvider) {
        this.m_provider = selectionProvider;
    }

    private ISelectionChangedListener createPushSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectionAdapter.this.pushSelection(event.getSelection());
            }
        };
    }

    private void pushSelection(ISelection selection) {
        Object[] objectArray = this.m_listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObject = objectArray[n2];
            SelectionChangedEvent se = new SelectionChangedEvent((ISelectionProvider)this, selection);
            ISelectionChangedListener listener = (ISelectionChangedListener)listenerObject;
            listener.selectionChanged(se);
            ++n2;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_listeners.add((Object)listener);
        if (this.m_listeners.size() == 1) {
            this.m_provider.addSelectionChangedListener(this.m_changeListener);
        }
    }

    protected ISelection convertSelection(ISelection selection) {
        if (!selection.isEmpty()) {
            if (selection instanceof IStructuredRowSelection) {
                IStructuredRowSelection sourceSelection = (IStructuredRowSelection)selection;
                LinkedList<Row> destintionRows = new LinkedList<Row>();
                Iterator it = sourceSelection.rowIterator();
                while (it.hasNext()) {
                    Row sourceRow = (Row)it.next();
                    Object converted = this.convertSelectedObject(sourceRow.ELEMENT);
                    if (converted == null) continue;
                    destintionRows.add(new Row(converted, sourceRow.COLUMNS));
                }
                return new StructuredRowSelection(destintionRows, sourceSelection.getFields());
            }
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                LinkedList<Object> result = new LinkedList<Object>();
                Iterator it = structuredSelection.iterator();
                while (it.hasNext()) {
                    Object converted = this.convertSelectedObject(it.next());
                    if (converted == null) continue;
                    result.add(converted);
                }
                return new StructuredSelection(result);
            }
        }
        return selection;
    }

    public abstract Object convertSelectedObject(Object var1);

    public ISelection getSelection() {
        return this.convertSelection(this.m_provider.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_listeners.remove((Object)listener);
        if (this.m_listeners.size() == 0) {
            this.m_provider.removeSelectionChangedListener(this.m_changeListener);
        }
    }

    public void setSelection(ISelection selection) {
        this.m_provider.setSelection(selection);
    }
}

