/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.CorePlugin;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class FilterMatcher {
    public static final char KLEENE_STAR = '*';
    public static final String KLEENE_STAR_STRING = Character.toString('*');
    public static final String REGEXP_PREFIX = "regexp:";
    private static final FilterMatcher instance = new FilterMatcher();
    private static volatile Pattern lastPattern = null;

    public static FilterMatcher getInstance() {
        return instance;
    }

    public boolean matchCaseUnsensitive(String stringToFilter, String filterString) {
        if (FilterMatcher.isUseRegexp(filterString)) {
            return this.match(stringToFilter, filterString);
        }
        return this.match(stringToFilter.toLowerCase(), filterString.toLowerCase());
    }

    public boolean match(String stringToFilter, String filterString) {
        if (FilterMatcher.isUseRegexp(filterString)) {
            String trimmedFilterString = filterString.substring(REGEXP_PREFIX.length()).trim();
            return this.regexpMatch(stringToFilter, trimmedFilterString);
        }
        return this.optimizedMatch(stringToFilter, filterString);
    }

    public boolean regexpMatch(String stringToFilter, String filterString) {
        Pattern pattern = lastPattern;
        if (pattern == null || !pattern.pattern().equals(filterString)) {
            try {
                pattern = Pattern.compile(filterString);
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.WARNING, "Failed to compile regexp.", e);
                return false;
            }
            lastPattern = pattern;
        }
        return pattern.matcher(stringToFilter).matches();
    }

    public boolean optimizedMatch(String stringToFilter, String filterString) {
        if (filterString.length() == 0) {
            return stringToFilter.length() == 0;
        }
        if (filterString.charAt(0) == '*') {
            filterString = filterString.substring(1);
            int n = 0;
            while (n <= stringToFilter.length()) {
                if (this.match(stringToFilter.substring(n), filterString)) {
                    return true;
                }
                ++n;
            }
        } else {
            if (stringToFilter.length() == 0) {
                return false;
            }
            if (filterString.charAt(0) == '?') {
                return this.match(stringToFilter.substring(1), filterString.substring(1));
            }
            if (filterString.charAt(0) == stringToFilter.charAt(0)) {
                return this.match(stringToFilter.substring(1), filterString.substring(1));
            }
        }
        return false;
    }

    public static String autoAddKleene(String filterText, Where where) {
        if (FilterMatcher.isUseRegexp(filterText)) {
            return filterText;
        }
        String newText = filterText;
        if (!(where != Where.BEFORE && where != Where.BEFORE_AND_AFTER || filterText.startsWith(KLEENE_STAR_STRING))) {
            newText = String.valueOf('*') + newText;
        }
        if (!(where != Where.AFTER && where != Where.BEFORE_AND_AFTER || filterText.endsWith(KLEENE_STAR_STRING))) {
            newText = String.valueOf(newText) + '*';
        }
        return newText;
    }

    private static boolean isUseRegexp(String filterString) {
        return filterString.startsWith(REGEXP_PREFIX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Where {
        BEFORE,
        AFTER,
        BEFORE_AND_AFTER;

    }
}

