/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.MCAccessibleListener;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IFieldListener;
import com.jrockit.mc.core.ui.fields.FieldFilter;
import com.jrockit.mc.core.ui.fields.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.WorkbenchJob;

public class FieldViewerFilterControl
extends Composite
implements IFieldListener {
    private final ViewerFilterRefreshJob m_refreshJob = new ViewerFilterRefreshJob();
    private final boolean m_showCombo;
    private Text m_filterText;
    private ComboViewer m_comboViewer;
    private FieldFilter m_fieldFilter = new FieldFilter(null, "");
    private Field[] m_fields;
    private StructuredViewer m_viewer;
    private Label filterLabel;

    public FieldViewerFilterControl(Composite parent, FormToolkit toolkit, boolean showCombo) {
        super(parent, 0);
        this.m_showCombo = showCombo;
        toolkit.paintBordersFor((Composite)this);
        this.create(toolkit, this);
    }

    public void initialize(StructuredViewer viewer, Field[] fields) {
        this.m_viewer = viewer;
        this.m_fields = fields;
        if (this.hasComboViewer()) {
            this.m_comboViewer.setInput((Object)fields);
        }
        if (this.m_fields.length > 0) {
            this.setFilteredField(this.m_fields[0]);
        }
        this.hookListeners();
        this.layout(true, true);
    }

    private void hookListeners() {
        int n = 0;
        while (n < this.m_fields.length) {
            this.m_fields[n].addListsner(this);
            ++n;
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this.m_fields.length) {
            this.m_fields[n].removeListener(this);
            ++n;
        }
    }

    public void changed(Field field, Object property) {
        if ("visibility.change".equals(property)) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.hasComboViewer()) {
            this.m_comboViewer.refresh();
        }
    }

    public void setFilteredField(Field field) {
        this.m_fieldFilter.setFilterField(field);
        this.m_fieldFilter.setFilterExpression("*");
        if (this.hasComboViewer()) {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)field));
        }
    }

    protected void create(FormToolkit toolkit, Composite parent) {
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        this.setLayout((Layout)layout);
        GridData gd0 = new GridData(4, 0x1000000, false, false);
        this.filterLabel = toolkit.createLabel(parent, "");
        if (this.m_showCombo) {
            this.filterLabel.setText(Messages.TableSectionPart_FILTER_COLUMN_TEXT);
        } else {
            this.filterLabel.setText(Messages.FieldViewerFilterControl_FILTER_SINGLE_COLUMN_TEXT);
        }
        this.filterLabel.setLayoutData((Object)gd0);
        if (this.m_showCombo) {
            GridData gd1 = new GridData(4, 4, false, false);
            this.m_comboViewer = this.createFilterCombo(toolkit, parent);
            this.m_comboViewer.getControl().setLayoutData((Object)gd1);
        }
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        this.m_filterText = toolkit.createText(parent, "", 0);
        this.m_filterText.setLayoutData((Object)gd2);
        this.m_filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && e.keyCode == 13) {
                    FieldViewerFilterControl.this.updateFilter(0L);
                }
            }
        });
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldViewerFilterControl.this.updateFilter(600L);
            }
        });
        this.m_filterText.setToolTipText(Messages.FieldViewerFilterControl_TYPE_FILTER_TOOLTIP_TEXT);
        if (CorePlugin.getDefault().getAccessibilityMode()) {
            MCAccessibleListener mcal = new MCAccessibleListener();
            mcal.setName(Messages.FieldViewerFilterControl_TYPE_FILTER_TOOLTIP_TEXT);
            this.m_filterText.getAccessible().addAccessibleListener((AccessibleListener)mcal);
        }
    }

    private ComboViewer createFilterCombo(FormToolkit toolkit, Composite parent) {
        ComboViewer viewer = new ComboViewer(parent);
        toolkit.adapt((Composite)viewer.getControl());
        viewer.setContentProvider((IContentProvider)new ComboProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ComboProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FieldViewerFilterControl.this.m_filterText != null && !FieldViewerFilterControl.this.m_filterText.isDisposed()) {
                    FieldViewerFilterControl.this.m_filterText.setText("");
                }
                if (FieldViewerFilterControl.this.m_viewer != null && !FieldViewerFilterControl.this.m_viewer.getControl().isDisposed()) {
                    FieldViewerFilterControl.this.m_viewer.refresh();
                }
            }
        });
        viewer.getCombo().setVisibleItemCount(10);
        return viewer;
    }

    boolean hasComboViewer() {
        return this.m_comboViewer != null && !this.m_comboViewer.getControl().isDisposed();
    }

    public void updateFilter(long delay) {
        if (this.m_filterText == null || this.m_filterText.isDisposed()) {
            return;
        }
        Field field = this.getFieldToFilter();
        if (field != null) {
            this.m_refreshJob.cancel();
            this.m_viewer.setFilters(new ViewerFilter[]{this.m_fieldFilter});
            this.m_fieldFilter.setFilterField(field);
            String filterExpressions = this.m_filterText.getText();
            this.m_fieldFilter.setFilterExpression(filterExpressions);
            if (delay > 0L) {
                this.m_refreshJob.schedule(delay);
            } else {
                this.m_viewer.refresh();
            }
        }
    }

    private Field getFieldToFilter() {
        if (this.m_showCombo) {
            if (this.hasComboViewer()) {
                return (Field)((IStructuredSelection)this.m_comboViewer.getSelection()).getFirstElement();
            }
        } else if (this.m_fields.length > 0) {
            return this.m_fields[0];
        }
        return null;
    }

    class ComboProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        ComboProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public String getText(Object element) {
            return ((Field)element).getName();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ViewerFilterRefreshJob
    extends WorkbenchJob {
        public ViewerFilterRefreshJob() {
            super("ViewerFilter Refresh Job");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            FieldViewerFilterControl.this.m_viewer.refresh();
            return Status.OK_STATUS;
        }
    }
}

