/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.Row;
import java.util.Comparator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FieldViewerComparator
extends ViewerComparator
implements Listener {
    private static final String IS_LAST_SORT_ORDER_ASCENDING = "VIEWER_SORT_ORDER_ASCENDING";
    public static final String SET_SORT_ORDER_ASCENDING = "SET_SORT_ORDER_ASCENDING";
    public static final String SET_SORT_ORDER_DESCENDING = "SET_SORT_ORDER_DESCENDING";
    private final Field m_field;
    private final int m_rowIndex;
    private final StructuredViewer m_viewer;
    private final Comparator<Object> m_comparator = new FieldComparator();
    protected boolean m_sortOrderAscending;

    public FieldViewerComparator(StructuredViewer viewer, Field field) {
        this(viewer, field, field.getSortOrderAscending());
    }

    public FieldViewerComparator(StructuredViewer viewer, Field field, boolean sortorderAscending) {
        this.m_viewer = viewer;
        this.m_field = field;
        this.m_rowIndex = field.INDEX;
        this.setSortOrderAscending(sortorderAscending);
    }

    public void handleEvent(Event event) {
        this.setSortOrderAscending(!this.getSortOrderAscendng());
        this.m_viewer.setComparator((ViewerComparator)this);
    }

    private void setSortOrderAscending(boolean b) {
        this.m_sortOrderAscending = b;
        this.m_field.setBoolean(IS_LAST_SORT_ORDER_ASCENDING, b);
    }

    public final int compare(Viewer viewer, Object e1, Object e2) {
        return this.m_comparator.compare(e1, e2);
    }

    public final Field getField() {
        return this.m_field;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public final boolean getSortOrderAscendng() {
        return this.m_field.getBoolean(IS_LAST_SORT_ORDER_ASCENDING, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FieldComparator
    implements Comparator<Object> {
        private FieldComparator() {
        }

        @Override
        public final int compare(Object argA, Object argB) {
            Object a = ((Row)argA).COLUMNS[FieldViewerComparator.this.m_rowIndex];
            if (a == null) {
                return 1;
            }
            Object b = ((Row)argB).COLUMNS[FieldViewerComparator.this.m_rowIndex];
            if (b == null) {
                return -1;
            }
            return FieldViewerComparator.this.m_field.compare(a, b, FieldViewerComparator.this.m_sortOrderAscending);
        }
    }
}

