/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IFieldListener;
import com.jrockit.mc.core.model.fields.IRowTreeSelection;
import com.jrockit.mc.core.model.fields.IStructuredRowSelection;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.model.fields.RowTreeSelection;
import com.jrockit.mc.core.ui.TreeLayout;
import com.jrockit.mc.core.ui.fields.CommonLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldViewerComparator;
import com.jrockit.mc.core.ui.fields.IFieldCellLabelProviderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldTreeViewer
extends TreeViewer {
    protected final Field[] m_fields;
    protected boolean m_noRefresh = false;
    protected FieldViewerComparator m_lastSorter;
    private ResourceManager rsrcManager;

    public FieldTreeViewer(Tree tree, Field[] fields) {
        this(tree, fields, (IBaseLabelProvider)new FieldLabelProvider(fields, (IBaseLabelProvider)new CommonLabelProvider()));
    }

    public FieldTreeViewer(Tree tree, Field[] fields, IBaseLabelProvider labelProvider) {
        super(tree);
        this.m_fields = fields;
        this.setUseHashlookup(true);
        tree.setHeaderVisible(this.m_fields.length > 1);
        tree.setLinesVisible(true);
        this.setLabelProvider(labelProvider);
        this.getTree().addControlListener((ControlListener)new ResizeListener());
        this.getTree().addKeyListener((KeyListener)new KeyExpander(this));
        this.hookVisibilityListeners();
    }

    public static FieldTreeViewer createWithStandardTree(Composite parent, Field[] fields) {
        Tree tree = new Tree(parent, 65794);
        return new FieldTreeViewer(tree, fields);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        this.refreshLayout(true);
    }

    protected void hookVisibilityListeners() {
        class RefreshColumnVisibilityListener
        implements IFieldListener {
            RefreshColumnVisibilityListener() {
            }

            public void changed(Field field, Object property) {
                if ("visibility.change".equals(property)) {
                    FieldTreeViewer.this.refreshLayout(true);
                }
                if ("content.change".equals(property)) {
                    Object[] exp = FieldTreeViewer.this.getExpandedElements();
                    FieldTreeViewer.this.refresh(true);
                    FieldTreeViewer.this.setExpandedElements(exp);
                }
                if ("SET_SORT_ORDER_ASCENDING".equals(property)) {
                    FieldTreeViewer.this.setComparator(new FieldViewerComparator((StructuredViewer)FieldTreeViewer.this, field, true));
                }
                if ("SET_SORT_ORDER_DESCENDING".equals(property)) {
                    FieldTreeViewer.this.setComparator(new FieldViewerComparator((StructuredViewer)FieldTreeViewer.this, field, false));
                }
            }
        }
        RefreshColumnVisibilityListener listener = new RefreshColumnVisibilityListener();
        int n = 0;
        while (n < this.m_fields.length) {
            this.m_fields[n].addListsner(listener);
            ++n;
        }
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        if (selection instanceof IRowTreeSelection) {
            IRowTreeSelection treeSelection = (IRowTreeSelection)selection;
            this.setSelectionToWidget(Arrays.asList(treeSelection.getRowPaths()), reveal);
        } else {
            super.setSelectionToWidget(selection, reveal);
        }
    }

    public ISelection getSelection() {
        Item[] items = this.getSelection(this.getControl());
        ArrayList<TreePath> list = new ArrayList<TreePath>(items.length);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            if (item.getData() != null) {
                list.add(this.getTreePathFromItem(item));
            }
            ++i;
        }
        return new RowTreeSelection(list.toArray(new TreePath[list.size()]), this.getComparer(), this.getFields());
    }

    public Field[] getFields() {
        return this.m_fields;
    }

    protected void updateLabels(TreeItem[] items) {
        if (items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            this.updateItem((Widget)items[i], items[i].getData());
            this.updateLabels(items[i].getItems());
            ++i;
        }
    }

    public void updateAllLabels() {
        this.updateLabels(this.getTree().getItems());
    }

    public void refresh(Object element) {
        try {
            this.getTree().setRedraw(false);
            super.refresh(element);
        }
        finally {
            this.getTree().setRedraw(true);
        }
    }

    public int getVisibleFieldCount() {
        int count = 0;
        int n = 0;
        while (n < this.m_fields.length) {
            count += this.m_fields[n].isVisible() ? 1 : 0;
            ++n;
        }
        return count;
    }

    private boolean isSingleColumnTree() {
        return this.m_fields.length == 1 && !this.getTree().getHeaderVisible();
    }

    public void refreshLayout(boolean rebuild) {
        if (!this.m_noRefresh && !this.isSingleColumnTree()) {
            this.m_noRefresh = true;
            try {
                if (this.getVisibleFieldCount() != this.getTree().getColumnCount() || rebuild) {
                    this.rebuildTable();
                    this.getTree().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!FieldTreeViewer.this.getTree().isDisposed()) {
                                FieldTreeViewer.this.refresh();
                            }
                        }
                    });
                } else {
                    this.layoutColumns();
                }
            }
            finally {
                this.m_noRefresh = false;
            }
        }
    }

    public void setComparator(ViewerComparator comparator) {
        if (this.getComparator() == comparator) {
            this.refresh();
        } else {
            super.setComparator(comparator);
        }
    }

    private void rebuildTable() {
        try {
            try {
                this.getTree().setRedraw(false);
                this.detroyColumns();
                this.addColumns();
                this.layoutColumns();
            }
            catch (Exception t) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not refresh table column layout", t);
                this.getTree().setRedraw(true);
            }
        }
        finally {
            this.getTree().setRedraw(true);
        }
    }

    private void detroyColumns() {
        int i = this.getTree().getColumnCount() - 1;
        while (i >= 0) {
            this.getTree().getColumn(i).dispose();
            --i;
        }
    }

    private void layoutColumns() {
        TreeLayout layout = new TreeLayout();
        int n = 0;
        while (n < this.m_fields.length) {
            if (this.m_fields[n].isVisible()) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.m_fields[n].getWidthWeight(), this.m_fields[n].getMinWidth(), true));
            }
            ++n;
        }
        this.getTree().setLayout((Layout)layout);
        this.getTree().layout();
    }

    public List getVisibleElements() {
        ArrayList<Object> elements = new ArrayList<Object>(this.getTree().getItemCount());
        FieldTreeViewer.collectElements(elements, this.getTree().getItems());
        return elements;
    }

    public void selectAll() {
        this.setSelection((ISelection)new StructuredSelection(this.getVisibleElements()));
    }

    private static void collectElements(List<Object> list, TreeItem[] parents) {
        int n = 0;
        while (n < parents.length) {
            if (parents[n].getExpanded()) {
                FieldTreeViewer.collectElements(list, parents[n].getItems());
            }
            list.add(parents[n].getData());
            ++n;
        }
    }

    private void addColumns() {
        IBaseLabelProvider treeLP = this.getLabelProvider();
        IFieldCellLabelProviderFactory factory = treeLP instanceof IFieldCellLabelProviderFactory ? (IFieldCellLabelProviderFactory)treeLP : null;
        int n = 0;
        while (n < this.m_fields.length) {
            if (this.m_fields[n].isVisible()) {
                TreeColumn treeColumn;
                int style;
                Field field = this.m_fields[n];
                int n2 = style = field instanceof NumberField ? 131072 : 0;
                if (factory != null) {
                    TreeViewerColumn viewerColumn = new TreeViewerColumn((TreeViewer)this, style);
                    viewerColumn.setLabelProvider(factory.createCellLabelProvider(field, this.getResourceManager()));
                    treeColumn = viewerColumn.getColumn();
                } else {
                    treeColumn = new TreeColumn(this.getTree(), style);
                }
                treeColumn.setText(field.getName());
                treeColumn.setMoveable(true);
                treeColumn.addListener(13, (Listener)new FieldViewerComparator((StructuredViewer)this, field));
                treeColumn.setToolTipText(field.getDescription());
            }
            ++n;
        }
    }

    protected ResourceManager getResourceManager() {
        if (this.rsrcManager == null) {
            this.rsrcManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getTree());
        }
        return this.rsrcManager;
    }

    public static class KeyExpander
    implements KeyListener {
        private final FieldTreeViewer m_viewer;

        public KeyExpander(FieldTreeViewer viewer) {
            this.m_viewer = viewer;
        }

        public void keyPressed(KeyEvent e) {
            IStructuredRowSelection sel;
            if (KeyExpander.isExpansionKey(e.keyCode) && !(sel = (IStructuredRowSelection)this.m_viewer.getSelection()).isEmpty()) {
                ArrayList list = new ArrayList(Arrays.asList(this.m_viewer.getExpandedElements()));
                list.addAll(sel.toRowList());
                this.m_viewer.setExpandedElements(list.toArray());
            }
        }

        private static boolean isExpansionKey(int keyCode) {
            return keyCode == 13;
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class ResizeListener
    implements ControlListener {
        private int m_lastWidth;

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            int width = ((Tree)e.getSource()).getClientArea().width;
            if (width != this.m_lastWidth) {
                FieldTreeViewer.this.refreshLayout(false);
                this.m_lastWidth = width;
            }
        }
    }
}

