/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTreeViewer;
import com.jrockit.mc.core.ui.fields.IFieldEditorControlFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class FieldTreeEditor {
    private final Map<String, IFieldEditorControlFactory> m_editableFieldSet = new LinkedHashMap<String, IFieldEditorControlFactory>();
    private final FieldTreeViewer m_viewer;
    private final TreeEditor m_treeEditor;

    public FieldTreeEditor(FieldTreeViewer viewer) {
        this.m_viewer = viewer;
        this.m_treeEditor = new TreeEditor(this.m_viewer.getTree());
        this.m_treeEditor.horizontalAlignment = 16384;
        this.m_treeEditor.grabHorizontal = true;
        this.m_treeEditor.minimumWidth = 50;
        this.m_viewer.getTree().addMouseListener((MouseListener)new TreeMouseListener(this));
    }

    public StructuredViewer getViewer() {
        return this.m_viewer;
    }

    public void editAt(int x, int y) {
        Control control;
        IFieldEditorControlFactory controlFactory;
        Field field;
        TreeItem[] items = this.m_viewer.getTree().getSelection();
        if (items != null && items.length > 0 && (field = this.getFieldAt(items[0], x, y)) != null && this.isEditable(field) && (controlFactory = this.m_editableFieldSet.get(field.IDENTIFIER)) != null && (control = controlFactory.createControl(this, field)) != null) {
            control.setFocus();
            int index = this.getVisibleColumnIndex(field);
            if (index != -1) {
                this.m_treeEditor.setEditor(control, items[0], index);
            }
        }
    }

    private boolean isEditable(Field field) {
        return this.m_editableFieldSet.containsKey(field.IDENTIFIER);
    }

    private Field getFieldAt(TreeItem item, int x, int y) {
        int index = 0;
        Field[] field = this.m_viewer.getFields();
        int n = 0;
        while (n < field.length) {
            if (field[n].isVisible()) {
                if (item.getBounds(index).contains(x, y)) {
                    return field[n];
                }
                ++index;
            }
            ++n;
        }
        return null;
    }

    public void disposeTreeEditor() {
        Control oldEditorControl = this.m_treeEditor.getEditor();
        if (oldEditorControl != null) {
            oldEditorControl.dispose();
            this.m_treeEditor.setEditor(null);
        }
    }

    public void addEditableField(Field field, IFieldEditorControlFactory factory) {
        this.m_editableFieldSet.put(field.IDENTIFIER, factory);
    }

    public void removeEditableField(Field field) {
        this.m_editableFieldSet.remove(field.IDENTIFIER);
    }

    private int getVisibleColumnIndex(Field column) {
        int index = 0;
        Field[] field = this.m_viewer.getFields();
        int n = 0;
        while (n < field.length) {
            if (field[n].isVisible()) {
                if (column.IDENTIFIER.equals(field[n].IDENTIFIER)) {
                    return index;
                }
                ++index;
            }
            ++n;
        }
        return -1;
    }

    public Object getSelected() {
        return ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
    }

    private static class TreeMouseListener
    extends MouseAdapter {
        private final FieldTreeEditor m_fieldTreeEditor;

        public TreeMouseListener(FieldTreeEditor fieldTreeEditor) {
            this.m_fieldTreeEditor = fieldTreeEditor;
        }

        public void mouseDown(MouseEvent e) {
            this.m_fieldTreeEditor.disposeTreeEditor();
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.m_fieldTreeEditor.disposeTreeEditor();
            this.m_fieldTreeEditor.editAt(e.x, e.y);
        }
    }
}

