/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.common.porting.JDK14Util;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogSettings;

public class FieldToolkit {
    static int SEVERITY_ERROR = 4;
    static int SEVERITY_WARNING = 2;
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    public static final String DIALOGSETTINGS_VALUE = "thevalue";
    static HashSet files;

    static {
        files = new HashSet();
    }

    public static int getIDfromName(String name) throws NumberFormatException {
        return Integer.parseInt(name);
    }

    public static String getNameFromID(int id) {
        return Integer.toString(id);
    }

    public static com.jrockit.mc.core.model.fields.Field getFieldFromIdentifier(String identifier, com.jrockit.mc.core.model.fields.Field[] fields) {
        try {
            int n = 0;
            while (n < fields.length) {
                if (fields[n].IDENTIFIER.equals(identifier)) {
                    return fields[n];
                }
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static void fillDialogSettingsFromFields(com.jrockit.mc.core.model.fields.Field[] fields, IDialogSettings settings) {
        int n = 0;
        while (n < fields.length) {
            try {
                String name = fields[n].IDENTIFIER;
                IDialogSettings fieldSetting = settings.getSection(name);
                if (fieldSetting == null) {
                    fieldSetting = settings.addNewSection(name);
                }
                Properties props = fields[n].getProperties();
                for (String string : props.keySet()) {
                    String value = props.getProperty(string);
                    String strippedKey = fields[n].getKeyFromProperty(string);
                    if (strippedKey == null || strippedKey.equals("NAME_TEXT") || strippedKey.equals("DESCRIPTION_TEXT")) continue;
                    FieldToolkit.storeSetting(fieldSetting, strippedKey, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public static void fillFieldsFromDialogSettings(IDialogSettings settings, com.jrockit.mc.core.model.fields.Field[] fields) {
        IDialogSettings[] fieldSettings = settings.getSections();
        int m = 0;
        while (m < fieldSettings.length) {
            try {
                com.jrockit.mc.core.model.fields.Field field = FieldToolkit.getFieldFromIdentifier(fieldSettings[m].getName(), fields);
                if (field != null) {
                    IDialogSettings[] properties = fieldSettings[m].getSections();
                    int n = 0;
                    while (n < properties.length) {
                        String key = properties[n].getName();
                        String value = properties[n].get(DIALOGSETTINGS_VALUE);
                        if (value != null && key != null) {
                            field.setProperty(key, value);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++m;
        }
    }

    private static void storeSetting(IDialogSettings fieldSetting, String key, Object value) {
        IDialogSettings fieldProperty = fieldSetting.getSection(key);
        if (fieldProperty == null) {
            fieldProperty = fieldSetting.addNewSection(key);
        }
        fieldProperty.put(DIALOGSETTINGS_VALUE, value.toString());
    }

    public static com.jrockit.mc.core.model.fields.Field[] instantiateFieldArray(com.jrockit.mc.core.model.fields.Field[] fieldPrototypes) {
        com.jrockit.mc.core.model.fields.Field[] fields = new com.jrockit.mc.core.model.fields.Field[]{};
        if (fieldPrototypes != null) {
            fields = new com.jrockit.mc.core.model.fields.Field[fieldPrototypes.length];
            int n = 0;
            while (n < fieldPrototypes.length) {
                fields[n] = fieldPrototypes[n].newInstance();
                ++n;
            }
        }
        return fields;
    }

    public static com.jrockit.mc.core.model.fields.Field[] getFields(Class clazz) {
        ArrayList<com.jrockit.mc.core.model.fields.Field> list = new ArrayList<com.jrockit.mc.core.model.fields.Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                Object object;
                if ((fieldArray[n].getModifiers() & 8) != 0 && (object = fieldArray[n].get(null)) instanceof com.jrockit.mc.core.model.fields.Field) {
                    com.jrockit.mc.core.model.fields.Field fieldObject = (com.jrockit.mc.core.model.fields.Field)object;
                    fieldObject.initialize(String.valueOf(JDK14Util.getSimpleName((Class)clazz)) + "_" + fieldArray[n].getName());
                    list.add(fieldObject);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        try {
            return list.toArray(new com.jrockit.mc.core.model.fields.Field[list.size()]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void initializeFields(Class clazz) {
        String name = clazz.getName();
        int lastPackageDot = name.lastIndexOf(46);
        FieldToolkit.initializeFields(String.valueOf(name.substring(0, lastPackageDot)) + ".fields", clazz);
    }

    public static void initializeFields(String bundleName, Class clazz) {
        com.jrockit.mc.core.model.fields.Field[] fields = FieldToolkit.getFields(clazz);
        Properties properties = new Properties();
        String[] variants = FieldToolkit.buildVariants(bundleName);
        ClassLoader loader = clazz.getClassLoader();
        int i = 0;
        while (i < variants.length) {
            block17: {
                InputStream input = loader.getResourceAsStream(variants[variants.length - 1 - i]);
                if (input != null) {
                    try {
                        try {
                            properties.load(input);
                            int n = 0;
                            while (n < fields.length) {
                                fields[n].setProperties(properties);
                                ++n;
                            }
                        }
                        catch (IOException e) {
                            System.err.println("Error loading " + variants[i]);
                            System.err.println(e);
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    public static boolean containsField(Class clazz, com.jrockit.mc.core.model.fields.Field[] fields, boolean onlyVisible) {
        int n = 0;
        while (n < fields.length) {
            if ((!onlyVisible || fields[n].isVisible()) && clazz.isInstance(fields[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

