/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IFieldListener;
import com.jrockit.mc.core.model.fields.IStructuredRowSelection;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.model.fields.StructuredRowSelection;
import com.jrockit.mc.core.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.core.ui.fields.CommonLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldFilter;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import com.jrockit.mc.core.ui.fields.FieldViewerComparator;
import com.jrockit.mc.core.ui.fields.IFieldCellLabelProviderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldTableViewer
extends TableViewer {
    protected final Field[] m_fields;
    protected boolean m_noRefresh = false;
    protected FieldViewerComparator m_lastSorter;
    private ViewerFilter[] m_filters;
    private ResourceManager rsrcManager;

    public static FieldTableViewer createWithStandardTable(Composite parent, Field[] fields) {
        Table table = new Table(parent, 268501762);
        return new FieldTableViewer(table, fields);
    }

    public FieldTableViewer(Table table, Field[] fields) {
        this(table, fields, (IBaseLabelProvider)new FieldLabelProvider(fields, (IBaseLabelProvider)new CommonLabelProvider()));
    }

    public FieldTableViewer(Table table, Field[] fields, IBaseLabelProvider labelProvider) {
        super(table);
        assert (fields != null);
        this.setFilters(new ViewerFilter[]{new FieldFilter()});
        this.m_fields = fields;
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setLabelProvider(labelProvider);
        table.addControlListener((ControlListener)new ResizeListener());
        this.hookVisibilityListeners();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        this.refreshLayout(true);
    }

    public void setFilters(ViewerFilter[] filters) {
        this.m_filters = filters;
    }

    public ViewerFilter[] getFilters() {
        return this.m_filters;
    }

    protected void hookVisibilityListeners() {
        class RefreshColumnVisibilityListener
        implements IFieldListener {
            RefreshColumnVisibilityListener() {
            }

            public void changed(Field field, Object property) {
                if ("visibility.change".equals(property) && !FieldTableViewer.this.getTable().isDisposed()) {
                    FieldTableViewer.this.refreshLayout(true);
                }
                if ("content.change".equals(property) && !FieldTableViewer.this.getTable().isDisposed()) {
                    FieldTableViewer.this.refresh(true);
                }
                if ("SET_SORT_ORDER_ASCENDING".equals(property)) {
                    FieldTableViewer.this.setComparator(new FieldViewerComparator((StructuredViewer)FieldTableViewer.this, field, true));
                }
                if ("SET_SORT_ORDER_DESCENDING".equals(property)) {
                    FieldTableViewer.this.setComparator(new FieldViewerComparator((StructuredViewer)FieldTableViewer.this, field, false));
                }
            }
        }
        RefreshColumnVisibilityListener listener = new RefreshColumnVisibilityListener();
        int n = 0;
        while (n < this.m_fields.length) {
            this.m_fields[n].addListsner(listener);
            ++n;
        }
    }

    public AbstractFieldTableContentProvider getFieldContentProvider() {
        if (this.getContentProvider() instanceof AbstractFieldTableContentProvider) {
            return (AbstractFieldTableContentProvider)this.getContentProvider();
        }
        return null;
    }

    public ISelection getSelection() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return new StructuredRowSelection(new Row[0], this.getFields());
        }
        List list = this.getSelectionFromWidget();
        return new StructuredRowSelection(list, this.getFields());
    }

    public void runWithPreservedSelection(Runnable runnable) {
        if (this.getFieldContentProvider() != null) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            runnable.run();
            if (!selection.isEmpty() && selection instanceof IStructuredRowSelection) {
                StructuredRowSelection rs = (StructuredRowSelection)selection;
                this.getTable().setSelection(this.getIndices(rs.toRowList()));
            }
        }
    }

    public void setComparator(final ViewerComparator sorter) {
        this.runWithPreservedSelection(new Runnable(){

            public void run() {
                if (sorter instanceof FieldViewerComparator) {
                    FieldTableViewer.this.m_lastSorter = (FieldViewerComparator)sorter;
                    FieldTableViewer.this.getFieldContentProvider().sort(FieldTableViewer.this.m_lastSorter.getComparator());
                    FieldTableViewer.this.internalRefresh();
                }
            }
        });
    }

    public void filter() {
        this.runWithPreservedSelection(new Runnable(){

            public void run() {
                FieldTableViewer.this.getFieldContentProvider().filter(FieldTableViewer.this.getFieldFilter());
                FieldTableViewer.this.internalRefresh();
            }
        });
    }

    public void internalRefresh() {
        if (this.getVisibleRowCount() != 0) {
            this.internalRefresh(this.getRoot());
        }
    }

    public void updateSortColumnVisibility() {
        if (this.m_lastSorter != null && this.m_lastSorter.getField() != null) {
            int columnIndex = 0;
            int n = 0;
            while (n < this.m_fields.length) {
                if (this.m_fields[n].isVisible()) {
                    if (this.m_fields[n].equals(this.m_lastSorter.getField()) && columnIndex < this.getTable().getColumnCount()) {
                        TableColumn column = this.getTable().getColumn(columnIndex);
                        if (column != null && !column.isDisposed()) {
                            this.getTable().setSortColumn(column);
                            this.getTable().setSortDirection(this.m_lastSorter.getSortOrderAscendng() ? 128 : 1024);
                        }
                        return;
                    }
                    ++columnIndex;
                }
                ++n;
            }
        }
    }

    public void refresh(final Object element) {
        this.runWithPreservedSelection(new Runnable(){

            public void run() {
                FieldTableViewer.this.getFieldContentProvider().refreshModel(element);
                if (FieldTableViewer.this.m_lastSorter != null) {
                    FieldTableViewer.this.getFieldContentProvider().sort(FieldTableViewer.this.m_lastSorter.getComparator());
                }
                FieldTableViewer.this.getFieldContentProvider().filter(FieldTableViewer.this.getFieldFilter());
                FieldTableViewer.this.getFieldContentProvider().updateItemCount();
                FieldTableViewer.this.internalRefresh();
            }
        });
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        int n = 0;
        while (n < this.m_fields.length) {
            this.m_fields[n].setInput(this.getInput());
            ++n;
        }
    }

    public Field[] getFields() {
        return this.m_fields;
    }

    public FieldFilter getFieldFilter() {
        ViewerFilter[] filters = this.getFilters();
        int n = 0;
        while (n < filters.length) {
            if (filters[n] instanceof FieldFilter) {
                return (FieldFilter)filters[n];
            }
            ++n;
        }
        return null;
    }

    public int getVisibleFieldCount() {
        int count = 0;
        int n = 0;
        while (n < this.m_fields.length) {
            count += this.m_fields[n].isVisible() ? 1 : 0;
            ++n;
        }
        return count;
    }

    public int[] getIndices(List<Object> list) {
        HashSet<Object> s = new HashSet<Object>(list);
        int size = s.size();
        int[] indices = new int[size];
        Object[] elements = this.getAllElements();
        int count = 0;
        int n = 0;
        while (n < elements.length) {
            if (s.contains(elements[n])) {
                indices[count++] = n;
            }
            ++n;
        }
        if (count < size) {
            int[] nArray = indices;
            indices = new int[count];
            System.arraycopy(nArray, 0, indices, 0, count);
        }
        return indices;
    }

    private boolean isSingleColumnTree() {
        return this.m_fields.length == 1 && !this.getTable().getHeaderVisible();
    }

    public void refreshLayout(boolean rebuild) {
        if (!this.m_noRefresh && !this.isSingleColumnTree()) {
            this.m_noRefresh = true;
            try {
                if (rebuild) {
                    this.rebuildTable();
                    this.getTable().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            FieldTableViewer.this.internalRefresh();
                        }
                    });
                } else {
                    this.layoutColumns();
                }
            }
            finally {
                this.m_noRefresh = false;
            }
        }
    }

    private void rebuildTable() {
        try {
            try {
                this.getTable().setRedraw(false);
                this.detroyColumns();
                this.addColumns();
                this.layoutColumns();
            }
            catch (Exception t) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not refresh table column layout", t);
                try {
                    this.getTable().setRedraw(true);
                }
                catch (SWTException sWTException) {}
            }
        }
        finally {
            try {
                this.getTable().setRedraw(true);
            }
            catch (SWTException sWTException) {}
        }
    }

    private void detroyColumns() {
        int i = this.getTable().getColumnCount() - 1;
        while (i >= 0) {
            this.getTable().getColumn(i).dispose();
            --i;
        }
    }

    private void layoutColumns() {
        TableLayout layout = new TableLayout();
        int n = 0;
        while (n < this.m_fields.length) {
            if (this.m_fields[n].isVisible()) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.m_fields[n].getWidthWeight(), this.m_fields[n].getMinWidth(), true));
            }
            ++n;
        }
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, true));
        this.getTable().setLayout((Layout)layout);
        this.getTable().layout();
    }

    private int getVisibleRowCount() {
        Object[] elements;
        if (this.getVisibleFieldCount() != 0 && (elements = this.getAllElements()) != null) {
            return elements.length;
        }
        return 0;
    }

    private void addColumns() {
        this.setItemCount(this.getVisibleRowCount());
        IBaseLabelProvider tableLP = this.getLabelProvider();
        IFieldCellLabelProviderFactory factory = tableLP instanceof IFieldCellLabelProviderFactory ? (IFieldCellLabelProviderFactory)tableLP : null;
        int n = 0;
        while (n < this.m_fields.length) {
            if (this.m_fields[n].isVisible()) {
                TableColumn tableColumn;
                int style;
                Field field = this.m_fields[n];
                int n2 = style = field instanceof NumberField ? 131072 : 0;
                if (factory != null) {
                    TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this, style);
                    viewerColumn.setLabelProvider(factory.createCellLabelProvider(field, this.getResourceManager()));
                    tableColumn = viewerColumn.getColumn();
                } else {
                    tableColumn = new TableColumn(this.getTable(), style);
                }
                tableColumn.setText(field.getName());
                tableColumn.setMoveable(true);
                tableColumn.addListener(13, (Listener)new FieldViewerComparator((StructuredViewer)this, field));
                tableColumn.setToolTipText(field.getDescription());
            }
            ++n;
        }
    }

    public Object[] getAllElements() {
        if (this.getFieldContentProvider() != null) {
            return this.getFieldContentProvider().getCurrentElements();
        }
        return new Row[0];
    }

    protected Widget doFindItem(Object element) {
        Item[] children = this.doGetItems();
        int i = 0;
        while (i < children.length) {
            Item item = children[i];
            Object data = item.getData();
            if (data instanceof Row && this.equals(((Row)data).getElement(), element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void selectAll() {
        this.getFieldContentProvider().setSelect(true);
        this.getTable().setSelection(this.getIndices(Arrays.asList(this.getAllElements())));
        this.getFieldContentProvider().setSelect(false);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void setSelection(ViewerFilter filter, boolean reveal) {
        ArrayList<Row> selected = new ArrayList<Row>();
        Object[] all = this.getAllElements();
        if (all instanceof Row[]) {
            Row[] rows = (Row[])all;
            int n = 0;
            while (n < rows.length) {
                if (filter.select((Viewer)this, null, rows[n].getElement())) {
                    selected.add(rows[n]);
                }
                ++n;
            }
        }
        this.setSelection((ISelection)new StructuredSelection((Object[])selected.toArray(new Row[selected.size()])), reveal);
    }

    protected ResourceManager getResourceManager() {
        if (this.rsrcManager == null) {
            this.rsrcManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getTable());
        }
        return this.rsrcManager;
    }

    public class ResizeListener
    implements ControlListener {
        private int m_lastWidth = Integer.MIN_VALUE;

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            int width = ((Table)e.getSource()).getClientArea().width;
            if (width != this.m_lastWidth) {
                FieldTableViewer.this.refreshLayout(false);
                this.m_lastWidth = width;
            }
        }
    }
}

