/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IFieldUI;
import com.jrockit.mc.core.ui.fields.Messages;
import com.jrockit.mc.core.ui.fields.TableSettingsDialog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldTableEditAction
extends Action {
    private IFieldUI[] m_fields;
    private boolean showSortOrderSetting;

    public FieldTableEditAction(IDialogSettings settings) {
        this(true);
    }

    public FieldTableEditAction(boolean showSortOrderSetting) {
        this.setText(Messages.TableSectionPart_TABLE_SETTINGS_TEXT);
        this.setToolTipText(Messages.TableSectionPart_TABLE_SETTINGS_TEXT);
        this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("settings_obj.gif"));
        this.showSortOrderSetting = showSortOrderSetting;
    }

    public void setFields(IFieldUI[] fields) {
        this.m_fields = fields;
    }

    public IFieldUI[] getFields() {
        return this.m_fields;
    }

    public void run() {
        Shell shell = Display.getCurrent().getActiveShell();
        HashSet<IFieldUI> beforeSet = new HashSet<IFieldUI>(FieldTableEditAction.getVisibleFields(this.getFields()));
        TableSettingsDialog tsd = new TableSettingsDialog(shell, this.m_fields, this.showSortOrderSetting);
        tsd.open();
        HashSet<IFieldUI> afterSet = new HashSet<IFieldUI>(FieldTableEditAction.getVisibleFields(this.m_fields));
        if (!beforeSet.equals(afterSet)) {
            if (this.m_fields.length > 0) {
                ((Field)this.m_fields[0]).setChanged();
                ((Field)this.m_fields[0]).notifyListeners("visibility.change");
            }
            this.notifyResult(true);
        }
    }

    static List<IFieldUI> getVisibleFields(IFieldUI[] fields) {
        ArrayList<IFieldUI> list = new ArrayList<IFieldUI>();
        if (fields != null) {
            int n = 0;
            while (n < fields.length) {
                if (fields[n].isVisible()) {
                    list.add(fields[n]);
                }
                ++n;
            }
        }
        return list;
    }
}

