/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.CaptionField;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldBaseRenderer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FieldRenderer
extends FieldBaseRenderer
implements DisposeListener {
    private final FormToolkit toolkit;
    private final Composite m_container;
    private final Map<Field, Text> m_textFieldMap = new HashMap<Field, Text>();
    private final Composite m_client;
    private final Menu m_menu;
    private final Font m_bold;
    private final Field PADDING = new CaptionField(0);

    public FieldRenderer(Composite parent, FormToolkit formToolkit, Menu menu, boolean scrolled) {
        this.PADDING.setName("");
        this.m_menu = menu;
        this.toolkit = formToolkit;
        if (scrolled) {
            this.m_client = this.toolkit.createScrolledForm(parent);
            this.m_container = ((ScrolledForm)this.m_client).getForm().getBody();
        } else {
            this.m_client = this.m_container = this.toolkit.createComposite(parent, 0);
        }
        this.m_bold = CorePlugin.getDefault().getFontColorToolkit().getStandardBoldFont();
        this.m_container.addDisposeListener((DisposeListener)this);
        this.toolkit.paintBordersFor(this.m_container);
    }

    public void render(Field[] fields) {
        this.m_textFieldMap.clear();
        int columnCount = FieldRenderer.getColumnCount(fields);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = columnCount;
        this.m_container.setLayout((Layout)layout);
        this.renderFields(fields);
        this.toolkit.paintBordersFor(this.m_container);
    }

    public void updateFields(Object[] data, Object input) {
        this.m_container.setRedraw(false);
        if (data != null) {
            for (Field field : this.m_textFieldMap.keySet()) {
                Text textWidget = this.m_textFieldMap.get(field);
                if (textWidget == null) continue;
                field.setInput(input);
                Object object = data[field.INDEX];
                String formattedText = object == null ? Field.defaultFormat(null) : field.formatObject(object);
                this.setToolTip(field, textWidget, object);
                textWidget.setText(formattedText);
            }
        }
        this.m_container.layout(true, true);
        this.m_container.setRedraw(true);
    }

    public void dispose() {
        this.m_textFieldMap.clear();
    }

    public Composite getClient() {
        return this.m_client;
    }

    private void setToolTip(Field field, Text textWdiget, Object object) {
        String toolTip = field.getTooltip(object);
        if (toolTip == null) {
            textWdiget.setToolTipText(field.getDescription());
        } else {
            textWdiget.setToolTipText(String.valueOf(field.getDescription()) + " " + toolTip);
        }
    }

    protected void renderLabel(Field field) {
        this.renderLabelWithStyle(field, false);
    }

    private void renderLabelWithStyle(Field field, boolean bold) {
        Label label = this.toolkit.createLabel(this.m_container, field.getName(), 0);
        label.setData("name", (Object)(String.valueOf(field.IDENTIFIER) + ".label"));
        if (bold && this.m_bold != null) {
            label.setFont(this.m_bold);
        }
        TableWrapData tableWrapData = new TableWrapData(128, 32);
        label.setLayoutData((Object)tableWrapData);
        if (this.m_menu != null) {
            label.setMenu(this.m_menu);
        }
    }

    protected void renderText(Field field) {
        Text text = this.toolkit.createText(this.m_container, "", 74);
        text.setData("name", (Object)(String.valueOf(field.IDENTIFIER) + ".text"));
        text.setToolTipText(field.getDescription());
        text.setLayoutData((Object)new TableWrapData(256, 256));
        text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.hookClearSelectionListener(text);
        this.m_textFieldMap.put(field, text);
    }

    private void hookClearSelectionListener(final Text text) {
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                text.clearSelection();
            }
        });
    }

    protected void renderCaption(Field field) {
        this.renderLabelWithStyle(field, true);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    protected void endRow(int padCount) {
        int n = 0;
        while (n < padCount) {
            this.renderLabel(this.PADDING);
            ++n;
        }
    }
}

