/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.ui.fields.FilterMatcher;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FieldFilter
extends ViewerFilter {
    public static final char KLEENE_STAR = '*';
    public static final String KLEENE_STAR_STRING = Character.toString('*');
    protected volatile String m_filterExpression;
    protected volatile Field m_filterField;

    public FieldFilter() {
    }

    public FieldFilter(Field filterField, String expression) {
        this.m_filterField = filterField;
        this.m_filterExpression = expression;
    }

    public void setFilterExpression(String expression) {
        this.m_filterExpression = expression;
    }

    public boolean hasValidFilter() {
        return this.m_filterField != null && this.m_filterExpression != null && this.m_filterExpression.length() != 0 && !this.m_filterExpression.equals(KLEENE_STAR_STRING);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof Row) {
            Row row = (Row)element;
            if (this.hasValidFilter()) {
                Object data = row.COLUMNS[this.m_filterField.INDEX];
                String filterString = this.m_filterField.formatObject(data);
                if (data != null && filterString != null) {
                    return FilterMatcher.getInstance().matchCaseUnsensitive(filterString, FilterMatcher.autoAddKleene(this.m_filterExpression, FilterMatcher.Where.AFTER));
                }
            }
        }
        return false;
    }

    public void setFilterField(Field field) {
        this.m_filterField = field;
    }
}

