/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.ui.fields.IFieldCellLabelProviderFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class FieldColumnLabelProvider
extends CellLabelProvider {
    protected final Field field;
    private ResourceManager rsrcManager;

    public FieldColumnLabelProvider(Field field, ResourceManager rsrcManager) {
        assert (field != null);
        this.field = field;
        assert (rsrcManager != null);
        this.rsrcManager = rsrcManager;
    }

    public void update(ViewerCell cell) {
        Row row = (Row)cell.getElement();
        Object cellElement = row.getColumn(this.field.INDEX);
        cell.setText(this.field.formatObject(cellElement));
        if (this.field.INDEX == 0) {
            cell.setImage(this.get(this.field.getImage(cellElement)));
        }
    }

    protected Image get(ImageDescriptor imgDesc) {
        return imgDesc != null ? (Image)this.rsrcManager.get((DeviceResourceDescriptor)imgDesc) : null;
    }

    public String getToolTipText(Object element) {
        return this.field.getTooltip(((Row)element).getColumn(this.field.INDEX));
    }

    public Image getToolTipImage(Object element) {
        return this.get(this.field.getToolTipImage(((Row)element).getColumn(this.field.INDEX)));
    }

    public boolean useNativeToolTip(Object object) {
        return false;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public static class Factory
    extends LabelProvider
    implements IFieldCellLabelProviderFactory {
        public CellLabelProvider createCellLabelProvider(Field field, ResourceManager resourceManager) {
            return new FieldColumnLabelProvider(field, resourceManager);
        }
    }
}

