/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.model.fields.CaptionField;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IComponentField;

public abstract class FieldBaseRenderer {
    protected abstract void renderLabel(Field var1);

    protected abstract void renderText(Field var1);

    protected void renderFields(Field[] fields) {
        int columnCount = FieldBaseRenderer.getColumnCount(fields);
        int n = 0;
        while (n < fields.length) {
            this.renderField(columnCount, fields[n]);
            ++n;
        }
    }

    protected boolean acceptField(Field field) {
        return field.isVisible();
    }

    protected void renderField(int totalColumnCount, Field field) {
        if (this.acceptField(field)) {
            if (totalColumnCount == 2) {
                if (field instanceof CaptionField) {
                    this.renderCaption(field);
                    this.endRow(1);
                } else {
                    this.renderLabel(field);
                    this.renderText(field);
                    this.endRow(0);
                }
            } else if (field instanceof IComponentField) {
                this.endRow(totalColumnCount - this.renderComponent((IComponentField)((Object)field)));
            } else {
                this.endRow(totalColumnCount - this.renderSimple(field));
            }
        }
    }

    protected abstract void renderCaption(Field var1);

    protected int renderSimple(Field field) {
        if (field instanceof CaptionField) {
            this.renderCaption(field);
        } else {
            this.renderText(field);
        }
        return 1;
    }

    protected abstract void endRow(int var1);

    protected static int getColumnCount(Field[] fields) {
        int count = 0;
        int n = 0;
        while (n < fields.length) {
            if (fields[n].isVisible()) {
                count = fields[n] instanceof IComponentField ? Math.max(((IComponentField)((Object)fields[n])).getChildren().length + 1, count) : Math.max(2, count);
            }
            ++n;
        }
        return count;
    }

    protected int renderComponent(IComponentField field) {
        this.renderLabel((Field)((Object)field));
        Field[] children = field.getChildren();
        int n = 0;
        while (n < field.getChildren().length) {
            this.renderSimple(children[n]);
            ++n;
        }
        return 1 + children.length;
    }
}

