/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.Row;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class FieldBackgroundPainter
implements Listener {
    private Field[] m_field;
    private double m_percentage;
    private int m_margin;

    public FieldBackgroundPainter(Field[] field, double percentage, int margin) {
        this.m_field = field;
        this.m_percentage = percentage;
        this.m_margin = margin;
    }

    public void handleEvent(Event event) {
        int visibleColumn = 0;
        int i = 0;
        while (i < this.m_field.length) {
            if (this.m_field[i].isVisible()) {
                if (visibleColumn == event.index) {
                    this.drawField(event, i);
                }
                ++visibleColumn;
            }
            ++i;
        }
    }

    public void drawColumnPercentage(Event event, double percentage, MCColor mccolor) {
        GC gc = event.gc;
        Display display = event.display;
        Color color = null;
        try {
            color = mccolor.createSWTColor((Device)display);
            gc.setBackground(color);
            int width = (int)(this.m_percentage * percentage * (double)event.getBounds().width + 0.5) - this.m_margin;
            if (width > 0) {
                gc.fillRectangle(event.x, event.y, width, event.getBounds().height);
            }
        }
        finally {
            if (color != null) {
                color.dispose();
            }
        }
    }

    private void drawField(Event event, int i) {
        Row row;
        Object element;
        Object data = event.item.getData();
        if (data instanceof Row && (element = (row = (Row)data).getElement()) != null) {
            Object columnValue = row.COLUMNS[i];
            this.drawFieldBackground(event, element, columnValue, this.m_field[i]);
        }
    }

    protected abstract void drawFieldBackground(Event var1, Object var2, Object var3, Field var4);
}

