/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.common.IMCAggregatedFrame;
import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.core.CorePlugin;
import java.lang.reflect.Modifier;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CommonLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        IMCAggregatedFrame mf;
        IMCAggregatedFrame.AggregationType t;
        if (element instanceof IMCAggregatedFrame && (t = (mf = (IMCAggregatedFrame)element).getAggregationType()) != null) {
            return this.getAggregatedFrameImage(t);
        }
        if (element instanceof IMCFrame) {
            IMCFrame f = (IMCFrame)element;
            if (f.getType() == "optimized") {
                return CorePlugin.getDefault().getImage("optimized-method-16.png");
            }
            if (f.getType() == "jitCompiled" || f.getType() == "inlined") {
                return CorePlugin.getDefault().getImage("non-optimized-method-16.png");
            }
            return CorePlugin.getDefault().getImage("stckframe_obj.gif");
        }
        if (element instanceof IMCMethod) {
            IMCMethod m = (IMCMethod)element;
            Integer modifier = m.getModifier();
            if (modifier != null) {
                this.getModifierImage(modifier);
            }
            return CorePlugin.getDefault().getImage("methdef_obj.gif");
        }
        if (element instanceof IMCType) {
            return CorePlugin.getDefault().getImage("class_obj.gif");
        }
        if (element instanceof IMCThread) {
            return this.getThreadImage((IMCThread)element);
        }
        return null;
    }

    private Image getAggregatedFrameImage(IMCAggregatedFrame.AggregationType type) {
        if (type == IMCAggregatedFrame.AggregationType.PREDECESSORS) {
            return CorePlugin.getDefault().getImage("callee.png");
        }
        if (type == IMCAggregatedFrame.AggregationType.PREDECESSORS) {
            return CorePlugin.getDefault().getImage("caller.png");
        }
        return CorePlugin.getDefault().getImage("stckframe_obj.gif");
    }

    private Image getThreadImage(IMCThread thread) {
        if (thread.isDeadlocked() != null && thread.isDeadlocked().booleanValue()) {
            return CorePlugin.getDefault().getImage("live-thread-deadlocked-16.PNG");
        }
        if ("BLOCKED".equalsIgnoreCase(thread.getThreadState())) {
            return CorePlugin.getDefault().getImage("live-thread-locked-16.png");
        }
        if ("WAITING".equalsIgnoreCase(thread.getThreadState())) {
            return CorePlugin.getDefault().getImage("live-thread-waiting-16.png");
        }
        if ("TIMED_WAITING".equalsIgnoreCase(thread.getThreadState())) {
            return CorePlugin.getDefault().getImage("live-thread-timewaiting-16.png");
        }
        if ("RUNNABLE".equalsIgnoreCase(thread.getThreadState())) {
            return CorePlugin.getDefault().getImage("thread_obj.gif");
        }
        if ("SUSPENDED".equalsIgnoreCase(thread.getThreadState())) {
            return CorePlugin.getDefault().getImage("threads_obj.gif");
        }
        if ("TERMINATED".equalsIgnoreCase(thread.getThreadState())) {
            return CorePlugin.getDefault().getImage("threadt_obj.gif");
        }
        return CorePlugin.getDefault().getImage("thread_obj.gif");
    }

    private Image getModifierImage(Integer modifier) {
        if (Modifier.isPublic(modifier)) {
            return CorePlugin.getDefault().getImage("methpub_obj.gif");
        }
        if (Modifier.isPrivate(modifier)) {
            return CorePlugin.getDefault().getImage("methpri_obj.gif");
        }
        if (Modifier.isProtected(modifier)) {
            return CorePlugin.getDefault().getImage("methpro_obj.gif");
        }
        return CorePlugin.getDefault().getImage("non-optimized-method-16.png");
    }
}

