/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IRowTreeSelection;
import com.jrockit.mc.core.model.fields.IStructuredRowSelection;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.ui.fields.FieldBaseRenderer;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class ClipboardManager {
    private static final ClipboardManager m_manager = new ClipboardManager();
    public final String LINE_SEPARATOR = System.getProperty("line.separator");
    public final String SPACE_INDENT = "   ";
    public final String TAB = "\t";
    public final String LEFT_PARENTHESIS = "(";
    public final String RIGHT_PARENTHESIS = ")";
    protected final Clipboard m_clipboard = new Clipboard(null);
    protected volatile boolean m_onlyVisible = false;
    protected volatile boolean m_asRawData = true;
    protected volatile boolean m_indenctForStructure = true;
    protected volatile boolean m_copyColumnHeaders = true;
    protected StringBuffer m_builder = null;
    protected boolean m_newLine = true;

    ClipboardManager() {
    }

    public static ClipboardManager getDefault() {
        return m_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyData(Field[] fields, final Object[] data) {
        FieldBaseRenderer clipBoardRender = new FieldBaseRenderer(){

            protected void renderLabel(Field field) {
                ClipboardManager.this.appendColumnSeparator();
                ClipboardManager.this.appendField(field);
            }

            protected void renderText(Field field) {
                ClipboardManager.this.appendColumnSeparator();
                ClipboardManager.this.appendData(data, field);
            }

            protected boolean acceptField(Field field) {
                return !ClipboardManager.this.shouldCopyOnlyVisible() || field.isVisible();
            }

            protected void endRow(int padCount) {
                int n = 0;
                while (n < padCount) {
                    ClipboardManager.this.appendColumnSeparator();
                    ++n;
                }
                ClipboardManager.this.appendNewLine();
            }

            protected void renderCaption(Field field) {
                if (ClipboardManager.this.m_copyColumnHeaders) {
                    this.renderLabel(field);
                }
            }
        };
        Clipboard clipboard = this.m_clipboard;
        synchronized (clipboard) {
            this.m_builder = new StringBuffer();
            clipBoardRender.renderFields(fields);
            this.setContents(this.m_builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copySelection(ISelection selection) {
        Clipboard clipboard = this.m_clipboard;
        synchronized (clipboard) {
            if (!selection.isEmpty()) {
                if (selection instanceof IRowTreeSelection) {
                    this.copyRowTreeSelection((IRowTreeSelection)selection);
                    return;
                }
                if (selection instanceof IStructuredRowSelection) {
                    this.copyRowSelection(selection);
                    return;
                }
                throw new IllegalArgumentException("ClipboardManager can't handle selections of type " + selection.getClass());
            }
        }
    }

    private void copyRowSelection(ISelection selection) {
        IStructuredRowSelection rs = (IStructuredRowSelection)selection;
        this.m_builder = new StringBuffer();
        if (this.getCopyColumnHeaders()) {
            this.copySelectionHeader(rs.getFields());
            this.appendNewLine();
        }
        this.copySelectionData(rs.getFields(), (IStructuredRowSelection)selection);
        this.setContents(this.m_builder.toString());
    }

    private void copyRowTreeSelection(IRowTreeSelection selection) {
        this.m_builder = new StringBuffer();
        TreePath[] paths = selection.getRowPaths();
        Field[] fields = selection.getFields();
        if (this.getCopyColumnHeaders()) {
            this.copySelectionHeader(fields);
            this.appendNewLine();
        }
        int i = 0;
        while (i < paths.length) {
            Row row = (Row)paths[i].getLastSegment();
            if (this.getIndentForStructure()) {
                this.appendSpaceIndent(paths[i].getSegmentCount() - 1);
            }
            this.appendRow(fields, row);
            this.appendNewLine();
            ++i;
        }
        this.setContents(this.m_builder.toString());
    }

    private void appendSpaceIndent(int indents) {
        int n = 0;
        while (n < indents) {
            this.m_builder.append("   ");
            ++n;
        }
    }

    public void dispose() {
        this.m_clipboard.dispose();
    }

    public boolean shouldCopyOnlyVisible() {
        return this.m_onlyVisible;
    }

    public boolean shouldCopyAsRawData() {
        return this.m_asRawData;
    }

    public void setCopyOnlyVisible(boolean onlyVisible) {
        this.m_onlyVisible = onlyVisible;
    }

    public void setCopyAsRawData(boolean asRawData) {
        this.m_asRawData = asRawData;
    }

    private void appendNewLine() {
        this.m_builder.append(this.LINE_SEPARATOR);
        this.m_newLine = true;
    }

    private void appendColumnSeparator() {
        if (!this.m_newLine) {
            this.m_builder.append("\t");
        } else {
            this.m_newLine = false;
        }
    }

    private void appendField(Field field) {
        this.m_builder.append(field.getName());
        String unit = field.getUnit();
        if (unit != null) {
            this.m_builder.append("(" + unit + ")");
        }
    }

    private void appendData(Object[] data, Field field) {
        Object dataObject = data[field.INDEX];
        if (dataObject != null) {
            if (this.shouldCopyAsRawData()) {
                this.m_builder.append(field.formatForClipboard(dataObject));
            } else {
                this.m_builder.append(field.formatObject(dataObject));
            }
        }
    }

    public void setContents(String text) {
        this.m_clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void copySelectionData(Field[] fields, IStructuredRowSelection selection) {
        Iterator it = selection.rowIterator();
        while (it.hasNext()) {
            this.appendRow(fields, (Row)it.next());
            this.appendNewLine();
        }
    }

    private void appendRow(Field[] fields, Row row) {
        int n = 0;
        while (n < fields.length) {
            if (!this.shouldCopyOnlyVisible() || fields[n].isVisible()) {
                this.appendColumnSeparator();
                this.appendData(row.getColumns(), fields[n]);
            }
            ++n;
        }
    }

    private void copySelectionHeader(Field[] fields) {
        int n = 0;
        while (n < fields.length) {
            if (!this.shouldCopyOnlyVisible() || fields[n].isVisible()) {
                this.appendColumnSeparator();
                this.appendField(fields[n]);
            }
            ++n;
        }
    }

    public boolean getIndentForStructure() {
        return this.m_indenctForStructure;
    }

    public void setIndentForStructure(boolean indent) {
        this.m_indenctForStructure = indent;
    }

    public boolean getCopyColumnHeaders() {
        return this.m_copyColumnHeaders;
    }

    public void setCopyColumnHeaders(boolean checked) {
        this.m_copyColumnHeaders = checked;
    }
}

