/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.fields;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.ui.fields.FieldFilter;
import com.jrockit.mc.core.ui.fields.FieldTableViewer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractFieldTableContentProvider
implements ILazyContentProvider {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Row[] EMPTY_ROW_ARRAY = new Row[0];
    private int m_index = 0;
    private Object[] m_allRows = EMPTY_ROW_ARRAY;
    private Object[] m_filterRows = null;
    private FieldTableViewer m_viewer = null;
    boolean m_select = false;

    public void sort(Comparator comparator) {
        if (this.m_viewer != null && comparator != null) {
            Arrays.sort(this.m_allRows, comparator);
            if (this.m_filterRows != null) {
                Arrays.sort(this.m_filterRows, comparator);
            }
        }
    }

    public Object[] getCurrentElements() {
        if (this.m_filterRows != null) {
            return this.m_filterRows;
        }
        return this.m_allRows;
    }

    public void filter(FieldFilter filter) {
        if (this.m_viewer != null) {
            if (filter != null && filter.hasValidFilter()) {
                this.m_filterRows = filter.filter((Viewer)this.m_viewer, new Object(), this.m_allRows);
                this.m_viewer.setItemCount(this.m_filterRows.length);
            } else {
                this.m_filterRows = null;
                this.m_viewer.setItemCount(this.m_allRows.length);
            }
        }
    }

    public void updateItemCount() {
        if (this.m_viewer != null) {
            if (this.m_filterRows != null) {
                this.m_viewer.setItemCount(this.m_filterRows.length);
            } else {
                this.m_viewer.setItemCount(this.m_allRows.length);
            }
        }
    }

    public void refreshModel(Object input) {
        if (this.m_viewer != null) {
            this.m_allRows = this.getElements(input);
            this.m_filterRows = null;
        }
    }

    public void setSelect(boolean select) {
        this.m_select = select;
    }

    public void updateElement(int index) {
        if (this.m_select) {
            return;
        }
        if (this.m_viewer != null) {
            if (this.m_filterRows != null) {
                this.m_viewer.replace(this.m_filterRows[index], index);
            } else {
                this.m_viewer.replace(this.m_allRows[index], index);
            }
        }
    }

    public final Object[] getElements(Object inputElement) {
        Object[] rows = EMPTY_ROW_ARRAY;
        try {
            Object[] rowElements = this.getRowElements(inputElement);
            if (rowElements != null) {
                rows = new Row[rowElements.length];
                this.m_index = 0;
                while (this.m_index < rowElements.length) {
                    rows[this.m_index] = new Row(rowElements[this.m_index], this.getColumnObject(rowElements[this.m_index]));
                    ++this.m_index;
                }
            }
        }
        catch (Throwable throwable) {
            CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Exception in ContentProvider Class" + this.getClass().getName(), throwable);
        }
        return rows;
    }

    public abstract Object[] getRowElements(Object var1);

    public abstract Object[] getColumnObject(Object var1);

    public int getIndex() {
        return this.m_index;
    }

    public void dispose() {
        this.m_allRows = null;
        this.m_filterRows = null;
        this.m_viewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.m_viewer = (FieldTableViewer)viewer;
        this.m_allRows = newInput != null ? this.getElements(newInput) : EMPTY_ROW_ARRAY;
        if (this.m_viewer != null) {
            if (CorePlugin.getDefault().isUnix()) {
                this.m_viewer.setItemCount(0);
            }
            this.m_viewer.setItemCount(this.m_allRows.length);
        }
    }
}

