/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.ui.dial.IDeviceDescription;
import com.jrockit.mc.core.ui.dial.ImageDescription;
import com.jrockit.mc.core.ui.dial.ShiftStep;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ShiftingDeviceDescription
implements IDeviceDescription {
    private final ShiftStep[] m_shifts;
    private String m_displayName;
    private String m_identifier;
    private boolean m_mirrorNegative;

    public ShiftingDeviceDescription(ShiftStep[] shifts, String displayName, String identifier, boolean mirroNegative) {
        this.m_shifts = shifts;
        this.m_displayName = displayName;
        this.m_identifier = identifier;
        this.m_mirrorNegative = mirroNegative;
    }

    private ShiftStep getShift(double value) {
        if (value < 0.0 && this.m_mirrorNegative) {
            int n = 0;
            while (n < this.m_shifts.length) {
                if (-this.m_shifts[n].getEnd() <= value && value <= -this.m_shifts[n].getStart()) {
                    return this.m_shifts[n];
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.m_shifts.length) {
                if (this.m_shifts[n].getStart() <= value && value <= this.m_shifts[n].getEnd()) {
                    return this.m_shifts[n];
                }
                ++n;
            }
        }
        return null;
    }

    public ImageDescription getImageDescription(double start, double end) {
        ShiftStep shift = this.getShift(end);
        if (shift == null) {
            return null;
        }
        return ImageDescription.createStandardConfiguration(shift.getImage());
    }

    public String getText(double start, double end) {
        ShiftStep s = this.getShift(end);
        return s == null ? "" : s.getDialText();
    }

    public double getNormalizationFactor(double start, double end) {
        ShiftStep s = this.getShift(end);
        return s == null ? Double.NEGATIVE_INFINITY : s.getNormalizationFactor();
    }

    public Point getSize() {
        Image image = CorePlugin.getDefault().getImage("dial_1_to_10.png");
        return new Point(image.getBounds().width, image.getBounds().height);
    }

    public String getDisplayname() {
        return this.m_displayName;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }
}

