/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.NormalizedScientificNotationField;
import com.jrockit.mc.core.ui.dial.IDeviceDescription;
import com.jrockit.mc.core.ui.dial.ImageDescription;
import com.jrockit.mc.core.ui.dial.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ScientificDeviceDescription
implements IDeviceDescription {
    public static String SCIENTIFIC_NOTATION = "scientific.notation";

    public ImageDescription getImageDescription(double start, double end) {
        return ImageDescription.createStandardConfiguration(CorePlugin.getDefault().getImage("dial_1_to_10.png"));
    }

    public String getText(double start, double end) {
        int exp = NormalizedScientificNotationField.calculateExponential(end);
        if (exp == 0) {
            return "";
        }
        return "\u00d710E" + exp;
    }

    private int getExponent(double end) {
        int exponent = -15;
        while (Math.pow(10.0, exponent) < end) {
            ++exponent;
        }
        return exponent;
    }

    public double getNormalizationFactor(double start, double end) {
        return Math.pow(10.0, this.getExponent(end));
    }

    public Point getSize() {
        Image image = CorePlugin.getDefault().getImage("dial_1_to_10.png");
        return new Point(image.getBounds().width, image.getBounds().height);
    }

    public String getDisplayname() {
        return Messages.ScientificDeviceDescription_SCIENTIFIC_NOTATION_TEXT;
    }

    public String getIdentifier() {
        return SCIENTIFIC_NOTATION;
    }
}

