/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.ui.dial.IDeviceDescription;
import com.jrockit.mc.core.ui.dial.ImageDescription;
import org.eclipse.swt.graphics.Point;

public class MultiRangeDeviceDescription
implements IDeviceDescription {
    private final IDeviceDescription[] m_descriptions;
    private final IDeviceDescription m_primary;

    public MultiRangeDeviceDescription(IDeviceDescription primary, IDeviceDescription[] backups) {
        this.m_descriptions = backups;
        this.m_primary = primary;
    }

    public IDeviceDescription getFirstValidDevice(double start, double end) {
        ImageDescription primary = this.m_primary.getImageDescription(start, end);
        if (primary == null) {
            int n = 0;
            while (n < this.m_descriptions.length) {
                if (this.m_descriptions[n].getImageDescription(start, end) != null) {
                    return this.m_descriptions[n];
                }
                ++n;
            }
        }
        return this.m_primary;
    }

    public ImageDescription getImageDescription(double start, double end) {
        return this.getFirstValidDevice(start, end).getImageDescription(start, end);
    }

    public double getNormalizationFactor(double start, double end) {
        return this.getFirstValidDevice(start, end).getNormalizationFactor(start, end);
    }

    public String getText(double start, double end) {
        return this.getFirstValidDevice(start, end).getText(start, end);
    }

    public Point getSize() {
        return this.m_primary.getSize();
    }

    public String getDisplayname() {
        return this.m_primary.getDisplayname();
    }

    public String getIdentifier() {
        return this.m_primary.getIdentifier();
    }
}

