/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.accessibility.FocusTracker;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.core.ui.dial.DialInformationViewer;
import com.jrockit.mc.core.ui.dial.DialViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class DialSectionPart
extends MCSectionPart {
    private DialViewer m_dialViewer;
    private DialInformationViewer m_dialInformationViewer;

    public DialSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    public abstract void addDials(DialViewer var1, DialInformationViewer var2);

    public boolean setFormInput(Object input) {
        boolean updated = false;
        updated = this.getDialViewer().setInput(input) || updated;
        updated = this.getDialInformationViewer().setInput(input) || updated;
        this.getDialViewer().refresh();
        this.getDialInformationViewer().refresh();
        return updated;
    }

    public void setFocus() {
        if (this.m_dialViewer != null && !this.m_dialViewer.isDisposed()) {
            this.m_dialViewer.setFocus();
        }
    }

    protected abstract void initializeSection(Section var1);

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.initializeSection(this.getSection());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.getSection().setLayout((Layout)layout);
        Composite client = this.createClient(form, this.getFormToolkit(), (Composite)this.getSection());
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getSection().setClient((Control)client);
        this.getFormToolkit().paintBordersFor(client);
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        Composite client = formToolkit.createComposite(section, 0);
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.widthHint = 50;
        this.m_dialViewer = new DialViewer(client, 0);
        FocusTracker.enableFocusTracking(this.m_dialViewer);
        this.m_dialViewer.setLayoutData(gd1);
        formToolkit.adapt((Composite)this.m_dialViewer);
        GridData gd2 = new GridData(4, 1, true, false);
        gd2.widthHint = 50;
        this.m_dialInformationViewer = new DialInformationViewer(client, formToolkit, 0);
        this.m_dialInformationViewer.setLayoutData(gd2);
        formToolkit.adapt((Composite)this.m_dialInformationViewer);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        client.setLayout((Layout)layout);
        return client;
    }

    public DialViewer getDialViewer() {
        return this.m_dialViewer;
    }

    public DialInformationViewer getDialInformationViewer() {
        return this.m_dialInformationViewer;
    }

    public void initializePart() {
        super.initializePart();
        this.addDials(this.getDialViewer(), this.getDialInformationViewer());
    }

    public String getDialTitle() {
        if (this.getDialViewer() != null && !this.getDialViewer().isDisposed()) {
            return this.getDialViewer().getTitle();
        }
        return null;
    }

    public boolean setDialTitle(Object value) {
        if (this.getDialViewer() != null && !this.getDialViewer().isDisposed()) {
            this.getDialViewer().setTitle((String)value);
            return true;
        }
        return false;
    }

    public void refreshPart() {
        super.refreshPart();
        this.getDialViewer().refresh();
        this.getDialInformationViewer().refresh();
    }
}

