/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.accessibility.FocusTracker;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.ui.dial.IDialInformationProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class DialInformationViewer
extends Composite {
    private final Map<String, DialInformationWidget> m_dialInformationWidgets = new LinkedHashMap<String, DialInformationWidget>();
    private final Map<String, IDialInformationProvider> m_dialInformation = new LinkedHashMap<String, IDialInformationProvider>();
    private final Map<String, Object> m_inputs = new LinkedHashMap<String, Object>();
    private final FormToolkit m_toolkit;

    public DialInformationViewer(Composite parent, FormToolkit toolkit, int style) {
        super(parent, style);
        this.m_toolkit = toolkit;
        this.addTraverseListener(new SimpleTraverseListener(true));
    }

    public IDialInformationProvider getDialInformationProvider(String identfier) {
        return this.m_dialInformation.get(identfier);
    }

    public void addDialInformationProvider(String identifier, IDialInformationProvider information) {
        this.m_dialInformation.put(identifier, information);
        this.disposeWidgets();
        this.createWidgets();
    }

    public void update() {
        this.layout(true);
    }

    public void removeDialInformationProvider(IDialInformationProvider information) {
        this.m_dialInformation.remove(information);
        this.disposeWidgets();
        this.createWidgets();
    }

    public void clear() {
        this.disposeWidgets();
        this.m_dialInformation.clear();
    }

    public boolean setInput(String identifier, Object input) {
        return this.m_inputs.put(identifier, input) != input;
    }

    public void refresh() {
        for (String identifier : this.m_dialInformationWidgets.keySet()) {
            DialInformationWidget widget = this.m_dialInformationWidgets.get(identifier);
            widget.setInput(this.getInput(identifier));
            widget.refresh();
        }
        this.update();
    }

    public boolean setInput(Object input) {
        boolean updated = false;
        for (String identifier : this.m_dialInformation.keySet()) {
            if (this.m_inputs.put(identifier, input) == input) continue;
            updated = true;
        }
        return updated;
    }

    public void dispose() {
        this.clear();
    }

    private Object getInput(String id) {
        return this.m_inputs.get(id);
    }

    private void createWidgets() {
        int columnIndex = 0;
        for (String identifier : this.m_dialInformation.keySet()) {
            IDialInformationProvider info = this.m_dialInformation.get(identifier);
            if (info == null) continue;
            TableWrapData td = new TableWrapData(256, 16);
            Control dialInfoWidget = this.createWidget(this.calculateStyle(columnIndex, this.m_dialInformation.size()), identifier, info);
            dialInfoWidget.setLayoutData((Object)td);
            ++columnIndex;
        }
        this.setLayout((Layout)this.createWidgetLayout(this.m_dialInformation.size()));
        this.layout(true, true);
    }

    private Control createWidget(int style, String identifier, IDialInformationProvider provider) {
        DialInformationWidget widget = new DialInformationWidget(this, this.m_toolkit, style, provider);
        this.m_toolkit.adapt((Composite)widget);
        this.m_dialInformationWidgets.put(identifier, widget);
        return widget;
    }

    private TableWrapLayout createWidgetLayout(int columnCount) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.numColumns = columnCount;
        layout.makeColumnsEqualWidth = true;
        return layout;
    }

    private int calculateStyle(int columnIndex, int columnCount) {
        if (columnCount > 1) {
            if (columnIndex == 0) {
                return 131072;
            }
            if (columnIndex == columnCount - 1) {
                return 16384;
            }
        }
        return 0x1000000;
    }

    private void disposeWidgets() {
        for (DialInformationWidget widget : this.m_dialInformationWidgets.values()) {
            widget.dispose();
        }
        this.m_dialInformationWidgets.clear();
    }

    private static class DialInformationWidget
    extends Composite {
        private final CLabel m_label;
        private final IDialInformationProvider m_provider;
        private Object m_input;

        public DialInformationWidget(Composite parent, FormToolkit toolkit, int style, IDialInformationProvider provider) {
            super(parent, 0);
            this.m_label = new CLabel((Composite)this, style);
            this.m_provider = provider;
            toolkit.adapt((Composite)this.m_label);
            this.setLayout((Layout)new FillLayout());
            this.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    DialInformationWidget.this.m_label.setFocus();
                }
            });
            FocusTracker.enableFocusTracking((Composite)this.m_label);
        }

        public void setInput(Object input) {
            this.m_input = input;
        }

        public void refresh() {
            String text = String.valueOf(this.m_provider.getName(this.m_input)) + " " + this.m_provider.getValue(this.m_input);
            this.m_label.setText(text);
            this.m_label.setToolTipText(this.m_provider.getDescription(this.m_input));
        }
    }
}

