/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.MCAccessibleListener;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.core.misc.ui.ColorConfigurationPage;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.ui.dial.DialConfiguration;
import com.jrockit.mc.core.ui.dial.IDeviceDescription;
import com.jrockit.mc.core.ui.dial.Messages;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DialConfigurationPage
extends WizardPage
implements IPerformFinishable {
    private final DialConfiguration m_dialConfiguration;
    private Button m_waterMark;
    private Text m_gradientBeginValue;
    private Text m_gradientEndValue;
    private Text m_title;
    private Text m_multiplier;
    private ComboViewer m_valueTypeComboViewer;
    private MCColor m_waterMarkColor;
    private MCColor m_gradientBeginColor;
    private MCColor m_gradientEndColor;
    private List m_deviceDescriptions;

    public DialConfigurationPage(DialConfiguration initial, List deviceDescriptions) {
        super(Messages.DialConfigurationWizard_CONFIGURE_DIAL_WIZARD_PAGE);
        this.m_dialConfiguration = initial;
        this.m_deviceDescriptions = deviceDescriptions;
        this.setDescription(Messages.DialConfigurationPage_DIAL_CONFIGURATION_TEXT);
    }

    public void createControl(Composite parent) {
        int columns = 2;
        GridLayout layout = new GridLayout(columns, false);
        parent.setLayout((Layout)layout);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.createTitle(parent, columns);
        this.createMultiplier(parent, columns);
        this.createType(parent, columns);
        this.createGradientBegin(parent, columns);
        this.createGradientEnd(parent, columns);
        this.createWatermark(parent, columns);
        this.createColors(parent);
        this.setControl((Control)parent);
        this.load();
        this.update();
    }

    protected ComboViewer getComboViewer() {
        return this.m_valueTypeComboViewer;
    }

    protected void createGradientEnd(Composite parent, int columns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.DialConfigurationPage_GRADIENT_END_VALUE_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = columns - 1;
        this.m_gradientEndValue = new Text(parent, 2048);
        this.m_gradientEndValue.setLayoutData((Object)gd);
        this.m_gradientEndValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialConfigurationPage.this.update();
            }
        });
    }

    protected void createGradientBegin(Composite parent, int columns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.DialConfigurationPage_GRADIENT_START_VALUE_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = columns - 1;
        this.m_gradientBeginValue = new Text(parent, 2048);
        this.m_gradientBeginValue.setLayoutData((Object)gd);
        this.m_gradientBeginValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialConfigurationPage.this.update();
            }
        });
    }

    protected void createWatermark(Composite parent, int columns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.DialConfigurationPage_SHOW_WATERMARK_CHECKBOX_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_waterMark = new Button(parent, 32);
        this.m_waterMark.setText("");
        this.m_waterMark.setLayoutData((Object)new GridData(4, 4, true, false));
        MCAccessibleListener mcAccessibleListener = new MCAccessibleListener();
        mcAccessibleListener.setName(label.getText());
        mcAccessibleListener.setDescription(label.getText());
        this.m_waterMark.getAccessible().addAccessibleListener((AccessibleListener)mcAccessibleListener);
    }

    protected void createTitle(Composite parent, int columns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.DialConfigurationPage_DIAL_TITLE_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_title = new Text(parent, 2048);
        this.m_title.setLayoutData((Object)new GridData(4, 4, true, false, columns - 1, 1));
        this.m_title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialConfigurationPage.this.update();
            }
        });
    }

    protected void createType(Composite parent, int columns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.DialConfigurationPage_DIAL_ATTRIBUTE_FORMATTING_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_valueTypeComboViewer = new ComboViewer(new CCombo(parent, 2048));
        this.m_valueTypeComboViewer.getCCombo().setVisibleItemCount(10);
        this.m_valueTypeComboViewer.setContentProvider((IContentProvider)new TypeProvider());
        this.m_valueTypeComboViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.m_valueTypeComboViewer.setSorter(new ViewerSorter());
        this.m_valueTypeComboViewer.setInput((Object)this.m_deviceDescriptions);
        this.m_valueTypeComboViewer.getCCombo().setEditable(false);
        this.m_valueTypeComboViewer.getCCombo().setLayoutData((Object)new GridData(4, 4, true, false, columns - 1, 1));
        this.m_valueTypeComboViewer.getCCombo().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    DialConfigurationPage.this.m_valueTypeComboViewer.getCCombo().getShell().setFocus();
                }
            }
        });
        this.m_valueTypeComboViewer.getCCombo().addTraverseListener((TraverseListener)new SimpleTraverseListener(true));
    }

    protected void createMultiplier(Composite parent, int columns) {
        Label label = new Label(parent, 0);
        label.setText(Messages.DialConfigurationPage_DIAL_MULTIPLIER_TEXT);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_multiplier = new Text(parent, 2048);
        this.m_multiplier.setLayoutData((Object)new GridData(4, 4, true, false, columns - 1, 1));
        this.m_multiplier.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialConfigurationPage.this.update();
            }
        });
    }

    protected void createColors(Composite parent) {
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 1;
        Button configureColors = new Button(parent, 0);
        configureColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorConfigurationPage cp = new ColorConfigurationPage();
                cp.addColorToConfigure("gradient.start.color", Messages.DialConfigurationPage_GRADIENT_START_COLOR_TEXT, DialConfigurationPage.this.m_gradientBeginColor);
                cp.addColorToConfigure("gradient.end.color", Messages.DialConfigurationPage_GRADIENT_END_COLOR_TEXT, DialConfigurationPage.this.m_gradientEndColor);
                cp.addColorToConfigure("watermark.color", Messages.DialConfigurationPage_WATERMARK_COLOR_TEXT, DialConfigurationPage.this.m_waterMarkColor);
                OnePageWizardDialog owd = new OnePageWizardDialog(DialConfigurationPage.this.getShell(), (IWizardPage)cp);
                owd.setImage(CorePlugin.getDefault().getImage("color-palette.gif"));
                owd.setTitle(cp.getTitle());
                if (owd.open() == 0) {
                    DialConfigurationPage.this.m_gradientBeginColor = cp.getColor("gradient.start.color");
                    DialConfigurationPage.this.m_gradientEndColor = cp.getColor("gradient.end.color");
                    DialConfigurationPage.this.m_waterMarkColor = cp.getColor("watermark.color");
                }
            }
        });
        this.setTitle(Messages.DialConfigurationPage_CONFIGURE_DIAL_TITLE_TEXT);
        configureColors.setText(Messages.DialConfigurationPage_BUTTON_COLORS_TEXT);
        configureColors.setLayoutData((Object)gd);
    }

    protected boolean validates() {
        boolean validates = true;
        validates = this.validateNumeric(this.m_multiplier.getText(), Messages.DialConfigurationPage_ERROR_MULTIPLIER_MUST_BE_NUMERIC_TEXT) && validates;
        validates = this.validateNumericeOrEmpty(this.m_gradientBeginValue.getText(), Messages.DialConfigurationPage_GRADIENT_START_MUST_BE_NUMERIC_OR_EMPTY_TEXT) && validates;
        validates = this.validateNumericeOrEmpty(this.m_gradientEndValue.getText(), Messages.DialConfigurationPage_GRADIENT_END_MUST_BE_NUMERIC_OR_EMPTY_TEXT) && validates;
        return validates;
    }

    protected boolean validateNumericeOrEmpty(String text, String display) {
        return text.trim().length() == 0 || this.validateNumeric(text, display);
    }

    protected boolean validateNumeric(String text, String display) {
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException nfe) {
            this.setMessage(display, 3);
            return false;
        }
    }

    private static String getGradientString(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "";
        }
        return Double.toString(d);
    }

    private static double getGradientValue(String s) {
        return s.trim().length() == 0 ? Double.NEGATIVE_INFINITY : Double.parseDouble(s);
    }

    protected void load() {
        this.m_waterMarkColor = this.m_dialConfiguration.getWatermarkColor();
        this.m_gradientBeginColor = this.m_dialConfiguration.getGradientBeginColor();
        this.m_gradientEndColor = this.m_dialConfiguration.getGradientEndColor();
        this.m_title.setText(this.m_dialConfiguration.getTitle());
        this.m_multiplier.setText(Double.toString(this.m_dialConfiguration.getMultiplier()));
        this.m_valueTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getDeviceDescription(this.m_dialConfiguration.getValueType())));
        this.m_gradientBeginValue.setText(DialConfigurationPage.getGradientString(this.m_dialConfiguration.getGradientBeginValue()));
        this.m_gradientEndValue.setText(DialConfigurationPage.getGradientString(this.m_dialConfiguration.getGradientEndValue()));
        this.m_waterMark.setSelection(this.m_dialConfiguration.getUseWatermark());
    }

    public IDeviceDescription getDeviceDescription(String identifier) {
        for (IDeviceDescription description : this.m_deviceDescriptions) {
            if (!identifier.equals(description.getIdentifier())) continue;
            return description;
        }
        return null;
    }

    protected void store() {
        this.m_dialConfiguration.setGradientBeginValue(DialConfigurationPage.getGradientValue(this.m_gradientBeginValue.getText()));
        this.m_dialConfiguration.setGradientEndValue(DialConfigurationPage.getGradientValue(this.m_gradientEndValue.getText()));
        this.m_dialConfiguration.setMultiplier(Double.parseDouble(this.m_multiplier.getText()));
        this.m_dialConfiguration.setUseWatermark(this.m_waterMark.getSelection());
        IDeviceDescription ide = (IDeviceDescription)((IStructuredSelection)this.m_valueTypeComboViewer.getSelection()).getFirstElement();
        this.m_dialConfiguration.setValueType(ide.getIdentifier());
        this.m_dialConfiguration.setTitle(this.m_title.getText());
        this.m_dialConfiguration.setWatermarkColor(this.m_waterMarkColor);
        this.m_dialConfiguration.setGradientBeginColor(this.m_gradientBeginColor);
        this.m_dialConfiguration.setGradientEndColor(this.m_gradientEndColor);
    }

    public DialConfiguration getConfiguration() {
        return this.m_dialConfiguration;
    }

    public void update() {
        this.setPageComplete(this.validates());
        if (this.isPageComplete()) {
            this.setMessage(null);
        }
    }

    public boolean performFinish() {
        this.store();
        return true;
    }

    protected static class TypeLabelProvider
    extends LabelProvider {
        protected TypeLabelProvider() {
        }

        public String getText(Object element) {
            return ((IDeviceDescription)element).getDisplayname();
        }
    }

    protected static class TypeProvider
    implements IStructuredContentProvider {
        protected TypeProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray(new IDeviceDescription[list.size()]);
            }
            return new IDeviceDescription[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

