/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.accessibility.FocusTracker;
import com.jrockit.mc.core.ui.dial.DialInformationViewer;
import com.jrockit.mc.core.ui.dial.DialViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class Dial {
    private Composite m_dialComposite;
    private DialViewer m_dialViewer;
    private DialInformationViewer m_dialInformationViewer;

    public boolean setInput(Object input) {
        boolean updated = false;
        updated = this.getDialViewer().setInput(input) || updated;
        updated = this.getDialInformationViewer().setInput(input) || updated;
        this.getDialViewer().refresh();
        this.getDialInformationViewer().refresh();
        return updated;
    }

    public Control getDialControl(Composite parent, FormToolkit toolkit, int style) {
        if (this.m_dialComposite == null) {
            this.initializeDialComposite(parent, toolkit, style);
        }
        return this.m_dialComposite;
    }

    protected Composite getDialCompositeInternal() {
        return this.m_dialComposite;
    }

    private void initializeDialComposite(Composite parent, FormToolkit formToolkit, int style) {
        this.m_dialComposite = new Composite(parent, style){

            public boolean setFocus() {
                if (Dial.this.m_dialViewer != null && !Dial.this.m_dialViewer.isDisposed()) {
                    return Dial.this.m_dialViewer.setFocus();
                }
                return Dial.this.m_dialComposite.setFocus();
            }
        };
        formToolkit.adapt(this.m_dialComposite);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_dialComposite.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, true);
        this.m_dialViewer = new DialViewer(this.m_dialComposite, 0);
        FocusTracker.enableFocusTracking(this.m_dialViewer);
        this.m_dialViewer.setLayoutData(gd1);
        formToolkit.adapt((Composite)this.m_dialViewer);
        GridData gd2 = new GridData(4, 1, true, false);
        this.m_dialInformationViewer = new DialInformationViewer(this.m_dialComposite, formToolkit, 0);
        this.m_dialInformationViewer.setLayoutData(gd2);
        formToolkit.adapt((Composite)this.m_dialInformationViewer);
        formToolkit.paintBordersFor(this.m_dialComposite);
    }

    public DialViewer getDialViewer() {
        return this.m_dialViewer;
    }

    protected DialInformationViewer getDialInformationViewer() {
        return this.m_dialInformationViewer;
    }
}

