/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui.dial;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.ui.dial.IDeviceDescription;
import com.jrockit.mc.core.ui.dial.Messages;
import com.jrockit.mc.core.ui.dial.MultiRangeDeviceDescription;
import com.jrockit.mc.core.ui.dial.ScientificDeviceDescription;
import com.jrockit.mc.core.ui.dial.ShiftStep;
import com.jrockit.mc.core.ui.dial.ShiftingDeviceDescription;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceDescriptionFactory {
    public static final String PERCENTAGE = "percentage";
    public static final String TIMESPAN_MS = "time.span.ms";
    public static final String TIMESPAN_S = "time.span.s";
    public static final String BYTES = "bytes";
    public static final String SMALL_NUMBER = "small.number";
    public static final String SCIENTIFIC_NOTATION = ScientificDeviceDescription.SCIENTIFIC_NOTATION;
    public static final String TIMESPAN_NS = "time.span.ns";
    private static final double s = 1.0;
    private static final double ms = 0.001;
    private static final double us = 1.0E-6;
    private static final double ns = 1.0E-9;
    private static final double minute = 60.0;
    private static final double hour = 3600.0;
    private static final double day = 86400.0;
    private static final double week = 604800.0;
    private static final double year = 3.1536E7;
    private static final double GB = 1.073741824E9;
    private static final double KB = 1024.0;
    private static final long THOUSAND = 1000L;
    private static final long BILLION = 1000000000L;
    public static final Image BACKGROUND_1_10 = CorePlugin.getDefault().getImage("dial_1_to_10.png");
    public static final Image BACKGROUND_10_100 = CorePlugin.getDefault().getImage("dial_10_to_100.png");
    public static final Image BACKGROUND_100_1000 = CorePlugin.getDefault().getImage("dial_100_to_1000.png");
    private static List<IDeviceDescription> s_descriptions;

    public static List<IDeviceDescription> getDeviceDescriptions() {
        if (s_descriptions == null) {
            s_descriptions = Arrays.asList(DeviceDescriptionFactory.createByteBackground(), DeviceDescriptionFactory.createPercentageBackground(), DeviceDescriptionFactory.createTimeSpanBackground(TIMESPAN_MS, 1000.0, Messages.DeviceDescriptionFactory_TIME_SPAN_MILLISECONDS_DIAL_TYPE), DeviceDescriptionFactory.createTimeSpanBackground(TIMESPAN_S, 1.0, Messages.DeviceDescriptionFactory_TIME_SPAN_SECONDS_DIAL_TYPE), DeviceDescriptionFactory.createTimeSpanBackground(TIMESPAN_NS, 1.0E9, Messages.DeviceDescriptionFactory_TIME_SPAN_NANOSECONDS_DIAL_TYPE), DeviceDescriptionFactory.createSmallNumbers(), new ScientificDeviceDescription());
        }
        return s_descriptions;
    }

    public static IDeviceDescription getDeviceDescription(String identifier, List deviceDescriptions) {
        for (IDeviceDescription description : deviceDescriptions) {
            if (!identifier.equals(description.getIdentifier())) continue;
            return description;
        }
        return null;
    }

    public static IDeviceDescription getDeviceDescription(String identifier) {
        return DeviceDescriptionFactory.getDeviceDescription(identifier, DeviceDescriptionFactory.getDeviceDescriptions());
    }

    public static IDeviceDescription createSmallNumbers() {
        return new MultiRangeDeviceDescription(new ShiftingDeviceDescription(new ShiftStep[]{new ShiftStep("", 0.0, 10.0, 10.0, BACKGROUND_1_10), new ShiftStep("", 10.0, 100.0, 100.0, BACKGROUND_10_100), new ShiftStep("", 100.0, 1000.0, 1000.0, BACKGROUND_100_1000)}, Messages.SemiScientificDeviceDescription_SMALL_NUMBERS_TEXT, SMALL_NUMBER, true), new IDeviceDescription[]{new ScientificDeviceDescription()});
    }

    public static IDeviceDescription createTimeSpanBackground(String identifier, double unitsPerSecond, String name) {
        return new MultiRangeDeviceDescription(new ShiftingDeviceDescription(new ShiftStep[]{new ShiftStep("ns", 0.0, unitsPerSecond * 10.0 * 1.0E-9, unitsPerSecond * 10.0 * 1.0E-9, BACKGROUND_1_10), new ShiftStep("ns", 0.0, unitsPerSecond * 100.0 * 1.0E-9, unitsPerSecond * 100.0 * 1.0E-9, BACKGROUND_10_100), new ShiftStep("ns", 0.0, unitsPerSecond * 1000.0 * 1.0E-9, unitsPerSecond * 1000.0 * 1.0E-9, BACKGROUND_100_1000), new ShiftStep("us", 0.0, unitsPerSecond * 10.0 * 1.0E-6, unitsPerSecond * 10.0 * 1.0E-6, BACKGROUND_1_10), new ShiftStep("us", 0.0, unitsPerSecond * 100.0 * 1.0E-6, unitsPerSecond * 100.0 * 1.0E-6, BACKGROUND_10_100), new ShiftStep("us", 0.0, unitsPerSecond * 1000.0 * 1.0E-6, unitsPerSecond * 1000.0 * 1.0E-6, BACKGROUND_100_1000), new ShiftStep("ms", 0.0, unitsPerSecond * 10.0 * 0.001, unitsPerSecond * 10.0 * 0.001, BACKGROUND_1_10), new ShiftStep("ms", 0.0, unitsPerSecond * 100.0 * 0.001, unitsPerSecond * 100.0 * 0.001, BACKGROUND_10_100), new ShiftStep("ms", 0.0, unitsPerSecond * 1000.0 * 0.001, unitsPerSecond * 1000.0 * 0.001, BACKGROUND_100_1000), new ShiftStep("s", 0.0, unitsPerSecond * 10.0, unitsPerSecond * 10.0 * 1.0, BACKGROUND_1_10), new ShiftStep("s", 0.0, unitsPerSecond * 100.0, unitsPerSecond * 100.0 * 1.0, BACKGROUND_10_100), new ShiftStep("minutes", 0.0, unitsPerSecond * 100.0, 60.0 * unitsPerSecond, BACKGROUND_10_100), new ShiftStep("hours", 0.0, unitsPerSecond * 100.0 * 60.0, 3600.0 * unitsPerSecond, BACKGROUND_10_100), new ShiftStep("days", 0.0, unitsPerSecond * 100.0 * 3600.0, 86400.0 * unitsPerSecond, BACKGROUND_1_10), new ShiftStep("weeks", 0.0, unitsPerSecond * 10.0 * 86400.0, 604800.0 * unitsPerSecond, BACKGROUND_10_100), new ShiftStep("years", 0.0, unitsPerSecond * 100.0 * 604800.0, 3.1536E7 * unitsPerSecond, BACKGROUND_1_10)}, name, identifier, true), new IDeviceDescription[]{new ScientificDeviceDescription()});
    }

    private static IDeviceDescription createByteBackground() {
        return new MultiRangeDeviceDescription(new ShiftingDeviceDescription(new ShiftStep[]{new ShiftStep("N/A", Double.NEGATIVE_INFINITY, -4.9E-324, 1.0, BACKGROUND_1_10), new ShiftStep(BYTES, 0.0, 10.0, 10.0, BACKGROUND_1_10), new ShiftStep(BYTES, 0.0, 100.0, 100.0, BACKGROUND_10_100), new ShiftStep(BYTES, 0.0, 1000.0, 1000.0, BACKGROUND_100_1000), new ShiftStep("kB", 0.0, 10000.0, 10240.0, BACKGROUND_1_10), new ShiftStep("kB", 0.0, 100000.0, 102400.0, BACKGROUND_10_100), new ShiftStep("kB", 0.0, 1000000.0, 1024000.0, BACKGROUND_100_1000), new ShiftStep("MB", 0.0, 1.0E7, 1.048576E7, BACKGROUND_1_10), new ShiftStep("MB", 0.0, 1.0E8, 1.048576E8, BACKGROUND_10_100), new ShiftStep("MB", 0.0, 1.0E9, 1.048576E9, BACKGROUND_100_1000), new ShiftStep("GB", 0.0, 1.0E10, 1.073741824E10, BACKGROUND_1_10), new ShiftStep("GB", 0.0, 1.0E11, 1.073741824E11, BACKGROUND_10_100), new ShiftStep("GB", 0.0, 1.0E12, 1.073741824E12, BACKGROUND_100_1000), new ShiftStep("TB", 0.0, 1.0E13, 1.099511627776E13, BACKGROUND_1_10), new ShiftStep("TB", 0.0, 1.0E14, 1.099511627776E14, BACKGROUND_10_100), new ShiftStep("TB", 0.0, 1.0E15, 1.099511627776E15, BACKGROUND_100_1000), new ShiftStep("PB", 0.0, 1.0E15, 1.125899906842624E16, BACKGROUND_1_10), new ShiftStep("PB", 0.0, 1.0E16, 1.125899906842624E17, BACKGROUND_10_100), new ShiftStep("PB", 0.0, 1.0E18, 1.125899906842624E18, BACKGROUND_100_1000)}, Messages.DeviceDescriptionFactory_MEMORY_DIAL_TYPE, BYTES, true), new IDeviceDescription[]{new ScientificDeviceDescription()});
    }

    private static IDeviceDescription createPercentageBackground() {
        return new MultiRangeDeviceDescription(new ShiftingDeviceDescription(new ShiftStep[]{new ShiftStep("%", 0.0, 1.0, 1.0, BACKGROUND_10_100)}, Messages.DeviceDescriptionFactory_PERCENT_DIAL_TYPE, PERCENTAGE, true), new IDeviceDescription[]{new ScientificDeviceDescription()});
    }

    public static IDeviceDescription createScientific() {
        return new ScientificDeviceDescription();
    }
}

