/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui;

import com.jrockit.mc.core.ui.VerticalSectionLayoutData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class VerticalSectionLayout
extends Layout {
    private final int marginWidth;
    private final int marginHeight;
    private final int verticalSpacing;
    private final boolean limitVerticalHeight;

    public VerticalSectionLayout() {
        this(true);
    }

    public VerticalSectionLayout(boolean limitVertical) {
        this(6, 6, 6, limitVertical);
    }

    public VerticalSectionLayout(int marginWidth, int marginHeight, int verticalSpacing) {
        this(marginWidth, marginHeight, verticalSpacing, true);
    }

    public VerticalSectionLayout(int marginWidth, int marginHeight, int verticalSpacing, boolean limitHeight) {
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
        this.verticalSpacing = verticalSpacing;
        this.limitVerticalHeight = limitHeight;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int[] heights;
        Rectangle clientRect = composite.getClientArea();
        if (hHint == -1) {
            hHint = clientRect.height;
        }
        if (wHint == -1) {
            wHint = clientRect.width;
        }
        if ((heights = this.calculateHeights(composite, wHint, hHint)).length == 0 || this.limitVerticalHeight) {
            return new Point(wHint, hHint);
        }
        int totalHeight = this.calculateTotalVerticalSpacing(composite);
        int i = 0;
        while (i < heights.length) {
            totalHeight += heights[i];
            ++i;
        }
        return new Point(clientRect.width, totalHeight += 2 * this.marginHeight);
    }

    private boolean isChildExpanded(Control child) {
        return child instanceof ExpandableComposite && ((ExpandableComposite)child).isExpanded();
    }

    private int calculateTotalVerticalSpacing(Composite composite) {
        int totalVerticalSpacing = 0;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.isChildExpanded(children[i])) {
                totalVerticalSpacing += this.verticalSpacing;
            }
            ++i;
        }
        return totalVerticalSpacing;
    }

    private int[] calculateHeights(Composite composite, int wHint, int hHint) {
        Control[] children = composite.getChildren();
        if (children.length == 0) {
            return new int[0];
        }
        int expanded = 0;
        int unexpandedHeight = 0;
        int[] heights = new int[children.length];
        int i = 0;
        while (i < children.length) {
            if (this.isChildExpanded(children[i])) {
                ++expanded;
            } else {
                heights[i] = children[i].computeSize((int)wHint, (int)-1).y;
                unexpandedHeight += heights[i];
            }
            ++i;
        }
        if (expanded > 0) {
            int expandedHeight = 0;
            int totalVerticalSpacing = this.verticalSpacing * (expanded - 1);
            int height = hHint - totalVerticalSpacing - 2 * this.marginHeight;
            int heightToSuggestToExpanded = this.limitVerticalHeight ? (int)((double)(height - unexpandedHeight) / ((double)expanded + 0.5)) : -1;
            int childrenThatCanAcceptMoreSpace = 0;
            int i2 = 0;
            while (i2 < children.length) {
                if (this.isChildExpanded(children[i2])) {
                    if (this.childCanAcceptMoreSpace(children[i2])) {
                        ++childrenThatCanAcceptMoreSpace;
                        heights[i2] = children[i2].computeSize((int)wHint, (int)heightToSuggestToExpanded).y;
                    } else {
                        heights[i2] = children[i2].computeSize((int)wHint, (int)-1).y;
                        if (heights[i2] > heightToSuggestToExpanded) {
                            heights[i2] = heightToSuggestToExpanded;
                        }
                    }
                    expandedHeight += heights[i2];
                }
                ++i2;
            }
            int remaining = height - (unexpandedHeight + expandedHeight);
            if (remaining > 0 && childrenThatCanAcceptMoreSpace > 0) {
                int part = (int)((float)remaining / (float)childrenThatCanAcceptMoreSpace);
                int i3 = 0;
                while (i3 < children.length) {
                    if (this.isChildExpanded(children[i3]) && this.childCanAcceptMoreSpace(children[i3])) {
                        if (expanded == 1) {
                            int n = i3;
                            heights[n] = heights[n] + remaining;
                            break;
                        }
                        int n = i3;
                        heights[n] = heights[n] + part;
                        remaining -= part;
                        --expanded;
                    }
                    ++i3;
                }
            }
        }
        return heights;
    }

    private boolean childCanAcceptMoreSpace(Control child) {
        Object layoutData = child.getLayoutData();
        if (layoutData instanceof VerticalSectionLayoutData) {
            return ((VerticalSectionLayoutData)layoutData).canAcceptMoreVerticalHeight();
        }
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle outerBounds = composite.getBounds();
        int[] heights = this.calculateHeights(composite, outerBounds.width, outerBounds.height);
        Control[] children = composite.getChildren();
        int y = this.marginHeight;
        int i = 0;
        while (i < children.length) {
            children[i].setBounds(outerBounds.x + this.marginWidth, y, outerBounds.width - 2 * this.marginWidth, heights[i]);
            y += heights[i];
            if (this.isChildExpanded(children[i])) {
                y += this.verticalSpacing;
            }
            ++i;
        }
    }
}

