/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui;

import com.jrockit.mc.core.ui.IWizardPageDetailPart;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public abstract class MasterDetailWizardPage
extends WizardPage
implements IMessageProvider,
IPreferencePageContainer,
ICheckStateListener {
    private ArrayList<IWizardPageDetailPart> m_detailParts = new ArrayList();
    private PageBook m_pageBook;
    private IWizardPageDetailPart m_activeDetailPart;
    private Group m_detailGroup;

    protected MasterDetailWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void onDetailSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            IWizardPageDetailPart detailPart = (IWizardPageDetailPart)structuredSelection.getFirstElement();
            this.setActiveDetailPart(detailPart);
            this.updateMessage();
        }
    }

    private void setActiveDetailPart(IWizardPageDetailPart detailPart) {
        if (this.m_activeDetailPart != null) {
            this.m_activeDetailPart.setVisible(false);
        }
        this.m_activeDetailPart = detailPart;
        this.m_pageBook.showPage(detailPart.getControl());
        this.m_activeDetailPart.setVisible(true);
        this.m_detailGroup.setText(detailPart.getName());
    }

    public abstract void registerDetailParts();

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.registerDetailParts();
        GridLayout layout = new GridLayout();
        this.createClient(container);
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
    }

    protected Composite createClient(Composite container) {
        GridData gd = new GridData(4, 4, true, true);
        SashForm sashForm = new SashForm(container, 256);
        GridData masterGridData = new GridData(4, 4, true, true);
        Composite master = this.createMaster((Composite)sashForm);
        master.setLayoutData((Object)masterGridData);
        GridData detailGridData = new GridData(4, 4, true, true);
        this.m_detailGroup = this.createDetail((Composite)sashForm);
        this.m_detailGroup.setLayoutData((Object)detailGridData);
        sashForm.setWeights(new int[]{2, 3});
        sashForm.setLayoutData((Object)gd);
        return sashForm;
    }

    protected Group createDetail(Composite parent) {
        GridLayout layout = new GridLayout();
        Group group = new Group(parent, 0);
        GridData gd2 = new GridData(4, 4, true, true);
        this.m_pageBook = new PageBook((Composite)group, 0);
        this.m_pageBook.setLayoutData((Object)gd2);
        for (IWizardPageDetailPart part : this.m_detailParts) {
            part.createPartControl((Composite)this.m_pageBook);
        }
        group.setLayout((Layout)layout);
        return group;
    }

    protected boolean isCurrentPage() {
        IWizardContainer c = this.getContainer();
        return c != null && this == c.getCurrentPage();
    }

    public void addDetailPart(IWizardPageDetailPart detailPart) {
        this.m_detailParts.add(detailPart);
    }

    public IWizardPageDetailPart getActiveDetailPart() {
        return this.m_activeDetailPart;
    }

    protected Composite createMaster(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new FillLayout());
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)group, (int)2048);
        viewer.addCheckStateListener((ICheckStateListener)this);
        viewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
        this.initializeViever((StructuredViewer)viewer);
        return group;
    }

    public String getErrorMessage() {
        IWizardPageDetailPart iw = this.getActiveDetailPart();
        if (iw != null) {
            return iw.getErrorMessage();
        }
        return super.getErrorMessage();
    }

    public String getMessage() {
        IWizardPageDetailPart iw = this.getActiveDetailPart();
        if (iw != null) {
            return iw.getMessage();
        }
        return super.getMessage();
    }

    public int getMessageType() {
        IWizardPageDetailPart iw = this.getActiveDetailPart();
        if (iw != null) {
            return iw.getMessageType();
        }
        return super.getMessageType();
    }

    protected Collection getDetailParts() {
        return this.m_detailParts;
    }

    protected void initializeViever(StructuredViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput((Object)this.getDetailParts());
        viewer.setLabelProvider((IBaseLabelProvider)new DetailLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new DetailPartSelectionListener());
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
        this.getContainer().updateButtons();
    }

    public void updateMessage() {
        this.getContainer().updateMessage();
    }

    public void updateTitle() {
        this.getContainer().updateTitleBar();
    }

    protected class CheckStateListener
    implements ICheckStateListener {
        protected CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            MasterDetailWizardPage.this.onDetailSelection((ISelection)new StructuredSelection(event.getElement()));
        }
    }

    protected static class DetailLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected DetailLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return ((IWizardPageDetailPart)element).getImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((IWizardPageDetailPart)element).getName();
        }
    }

    protected class DetailPartSelectionListener
    implements ISelectionChangedListener {
        protected DetailPartSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            MasterDetailWizardPage.this.onDetailSelection(event.getSelection());
        }
    }
}

