/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.SimpleTraverseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class MCToolBarManager {
    public static int ALIGN_LEFT = 0;
    public static int ALIGN_CENTER_LEFT = 10;
    public static int ALIGN_CENTER = 20;
    public static int ALIGN_CENTER_RIGHT = 30;
    public static int ALIGN_RIGHT = 40;
    private final IPropertyChangeListener actionListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty() != "enabled" || MCToolBarManager.this.getToolBar().isDisposed()) {
                return;
            }
            IAction action = (IAction)event.getSource();
            Control[] controls = MCToolBarManager.this.getToolBar().getChildren();
            int n = 0;
            while (n < controls.length) {
                ToolbarItem tbi = (ToolbarItem)controls[n].getData();
                if (tbi.getAction() == action) {
                    MCToolBarManager.this.updateImage((ImageHyperlink)controls[n], action);
                    return;
                }
                ++n;
            }
        }
    };
    private final Composite m_parent;
    private final ArrayList<ToolbarItem> m_list = new ArrayList();
    private Composite m_toolbar;
    private LocalResourceManager m_localResourceManager;

    public MCToolBarManager(Composite parent) {
        this.m_parent = parent;
    }

    public Composite getParent() {
        return this.m_parent;
    }

    public void dispose() {
        if (this.m_toolbar != null && !this.m_toolbar.isDisposed()) {
            this.m_toolbar.dispose();
        }
        if (this.m_localResourceManager != null) {
            this.m_localResourceManager.dispose();
        }
        if (this.m_list != null) {
            for (ToolbarItem tbi : this.m_list) {
                tbi.getAction().removePropertyChangeListener(this.actionListener);
            }
            this.m_list.clear();
        }
        this.m_localResourceManager = null;
    }

    public List getActions() {
        ArrayList<IAction> list = new ArrayList<IAction>();
        for (ToolbarItem item : this.m_list) {
            list.add(item.getAction());
        }
        return Collections.unmodifiableList(list);
    }

    public void update() {
        this.disposeToolbarItems();
        for (ToolbarItem item : this.m_list) {
            this.createWidget(item, this.getToolBar());
        }
        this.getToolBar().getParent().redraw();
        this.getToolBar().update();
        this.getToolBar().layout(true, true);
        this.getToolBar().getParent().layout(true, true);
    }

    public Composite getToolBar() {
        if (this.m_toolbar == null) {
            this.m_toolbar = new Composite(this.getParent(), 0);
            RowLayout layout = new RowLayout(256);
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.spacing = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            this.m_toolbar.setLayout((Layout)layout);
        }
        return this.m_toolbar;
    }

    public void add(IAction action, int alignment) {
        this.m_list.add(new ToolbarItem(action, alignment));
        Collections.sort(this.m_list);
        this.update();
        action.addPropertyChangeListener(this.actionListener);
    }

    public void add(IAction action) {
        this.add(action, ALIGN_CENTER);
    }

    public void remove(IAction action) {
        action.removePropertyChangeListener(this.actionListener);
        Control[] children = this.getToolBar().getChildren();
        int n = 0;
        while (n < children.length) {
            ToolbarItem item = (ToolbarItem)children[n].getData();
            if (action.equals(item.getAction())) {
                this.m_list.remove(item);
                this.update();
                return;
            }
            ++n;
        }
    }

    private ToolbarItem getToolbarItem(HyperlinkEvent e) {
        return (ToolbarItem)e.widget.getData();
    }

    private void setImage(ImageHyperlink imageHyperLink, ImageDescriptor imageDescriptor) {
        if (imageHyperLink != null && imageDescriptor != null) {
            try {
                imageHyperLink.setImage(this.getResourceManager().createImage(imageDescriptor));
                imageHyperLink.redraw();
                imageHyperLink.update();
            }
            catch (DeviceResourceException deviceResourceException) {
                // empty catch block
            }
        }
    }

    private LocalResourceManager getResourceManager() {
        if (this.m_localResourceManager == null) {
            this.m_localResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.m_localResourceManager;
    }

    private boolean isCheckable(IAction action) {
        return action != null && (action.getStyle() & 2) != 0;
    }

    private boolean isRadioable(IAction action) {
        return action != null && (action.getStyle() & 8) != 0;
    }

    protected boolean isHoverable(IAction action) {
        return action != null && action.getHoverImageDescriptor() != null;
    }

    private void updateImage(ImageHyperlink imageHyperLink, IAction action) {
        if (action.isEnabled()) {
            if (this.isCheckable(action) || this.isRadioable(action)) {
                if (action.isChecked()) {
                    this.setImage(imageHyperLink, action.getImageDescriptor());
                } else {
                    this.setImage(imageHyperLink, action.getDisabledImageDescriptor());
                }
            } else {
                this.setImage(imageHyperLink, action.getImageDescriptor());
            }
        } else {
            this.setImage(imageHyperLink, action.getDisabledImageDescriptor());
        }
    }

    private void disposeToolbarItems() {
        if (!this.getToolBar().isDisposed()) {
            Control[] controls = this.getToolBar().getChildren();
            int n = 0;
            while (n < controls.length) {
                controls[n].setData(null);
                controls[n].dispose();
                ++n;
            }
        }
    }

    private void createWidget(ToolbarItem item, Composite parent) {
        ImageHyperlink imageHyperLink = new ImageHyperlink(parent, 0x1000000);
        imageHyperLink.setToolTipText(item.getAction().getToolTipText());
        IPreferenceStore corePreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        boolean buttonsAsText = corePreferenceStore.getBoolean("accessibility.buttonsAsText");
        if (buttonsAsText) {
            imageHyperLink.setText(item.getAction().getText());
        }
        imageHyperLink.setBackgroundImage(this.getParent().getBackgroundImage());
        imageHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperLinkListener());
        imageHyperLink.setData((Object)item);
        imageHyperLink.addTraverseListener((TraverseListener)new SimpleTraverseListener(true));
        this.updateImage(imageHyperLink, item.getAction());
    }

    public class HyperLinkListener
    implements IHyperlinkListener {
        public void linkActivated(HyperlinkEvent e) {
            ToolbarItem activatedItem = MCToolBarManager.this.getToolbarItem(e);
            if (activatedItem != null) {
                IAction activatedAction = activatedItem.getAction();
                if (MCToolBarManager.this.isRadioable(activatedAction)) {
                    Control[] children = MCToolBarManager.this.getToolBar().getChildren();
                    int n = 0;
                    for (ToolbarItem item : MCToolBarManager.this.m_list) {
                        ImageHyperlink imageHyperLink = (ImageHyperlink)children[n++];
                        IAction action = item.getAction();
                        if (!MCToolBarManager.this.isRadioable(action) || action == activatedItem.getAction()) continue;
                        action.setChecked(false);
                        MCToolBarManager.this.updateImage(imageHyperLink, action);
                    }
                    activatedAction.setChecked(true);
                    MCToolBarManager.this.updateImage((ImageHyperlink)e.widget, activatedAction);
                }
                if (MCToolBarManager.this.isCheckable(activatedAction)) {
                    activatedAction.setChecked(!activatedAction.isChecked());
                    MCToolBarManager.this.updateImage((ImageHyperlink)e.widget, activatedAction);
                }
                if (activatedAction.isEnabled()) {
                    activatedAction.run();
                }
            }
        }

        public void linkEntered(HyperlinkEvent e) {
            ToolbarItem item = MCToolBarManager.this.getToolbarItem(e);
            if (item != null) {
                MCToolBarManager.this.setImage((ImageHyperlink)e.widget, item.getAction().getHoverImageDescriptor());
            }
        }

        public void linkExited(HyperlinkEvent e) {
            ToolbarItem item = MCToolBarManager.this.getToolbarItem(e);
            if (item != null) {
                MCToolBarManager.this.updateImage((ImageHyperlink)e.widget, item.getAction());
            }
        }
    }

    private static class ToolbarItem
    implements Comparable {
        private final int m_alignment;
        private final IAction m_action;

        public ToolbarItem(IAction action, int alignMent) {
            this.m_alignment = alignMent;
            this.m_action = action;
        }

        public IAction getAction() {
            return this.m_action;
        }

        public int getAlignment() {
            return this.m_alignment;
        }

        public int compareTo(Object arg0) {
            ToolbarItem t = (ToolbarItem)arg0;
            return this.getAlignment() - t.getAlignment();
        }
    }
}

