/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.ui;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MCBook
extends Composite {
    private Control m_currentPage = null;

    public MCBook(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new PageBookLayout());
    }

    public void showPageWithData(Object object, String key) {
        Control[] children = this.getChildren();
        int n = 0;
        while (n < children.length) {
            if (object.equals(children[n].getData(key))) {
                this.showPage(children[n]);
                return;
            }
            ++n;
        }
    }

    public void showPage(Control page) {
        if (page != this.m_currentPage && page.getParent() == this) {
            Control oldPage = this.m_currentPage;
            this.m_currentPage = page;
            if (page != null && !page.isDisposed()) {
                page.setVisible(true);
                this.layout(true);
            }
            if (oldPage != null && !oldPage.isDisposed()) {
                oldPage.setVisible(false);
            }
        }
    }

    private class PageBookLayout
    extends Layout {
        private PageBookLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point noneWrappedChildren = this.calculateSize(composite, wHint, hHint, flushCache, false);
            Point wrappedChildren = this.calculateSize(composite, noneWrappedChildren.x, hHint, flushCache, true);
            return new Point(Math.max(noneWrappedChildren.x, wrappedChildren.x), Math.max(noneWrappedChildren.y, wrappedChildren.y));
        }

        private Point calculateSize(Composite composite, int wHint, int hHint, boolean flushCache, boolean wrapped) {
            Point max = new Point(0, 0);
            Control[] children = composite.getChildren();
            int n = 0;
            while (n < children.length) {
                if (children[n] != null && (0x40 & children[n].getStyle()) > 0 == wrapped) {
                    Point result = children[n].computeSize(wHint, hHint, flushCache);
                    if (wHint != -1) {
                        result.x = wHint;
                    }
                    if (hHint != -1) {
                        result.y = hHint;
                    }
                    max.x = Math.max(result.x, max.x);
                    max.y = Math.max(result.y, max.y);
                }
                ++n;
            }
            return max;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (MCBook.this.m_currentPage != null) {
                MCBook.this.m_currentPage.setBounds(composite.getClientArea());
            }
        }
    }
}

