/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.site;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.site.AbstractSiteActivator;
import com.jrockit.mc.core.site.IServiceRegistry;
import com.jrockit.mc.core.site.SelectionProviderActivator;
import com.jrockit.mc.core.site.ServiceRegistry;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IMenuService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionSite
implements IServiceRegistry {
    private final IWorkbenchPartSite m_parentSite;
    private final SelectionProviderActivator m_selectionActivator;
    private final Vector<AbstractSiteActivator> m_activators = new Vector();
    private final IServiceRegistry m_registry;
    private String m_id;
    private Vector<AbstractSiteActivator> m_currentActivated;

    public SectionSite(String id, IWorkbenchPartSite parentSite, IServiceRegistry registry) {
        this.m_parentSite = parentSite;
        this.m_id = id;
        this.m_selectionActivator = new SelectionProviderActivator(parentSite);
        this.m_activators.add(this.m_selectionActivator);
        this.m_registry = registry == null ? new ServiceRegistry() : registry;
    }

    public IServiceRegistry getServiceRegistry() {
        return this.m_registry;
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isActivated() {
        return this.m_currentActivated != null;
    }

    public void activate() {
        if (!this.isActivated()) {
            this.m_currentActivated = new Vector();
            AbstractSiteActivator[] activations = this.m_activators.toArray(new AbstractSiteActivator[0]);
            int n = 0;
            while (n < activations.length) {
                try {
                    activations[n].activate();
                    this.m_currentActivated.add(activations[n]);
                }
                catch (Exception e) {
                    CorePlugin.getDefault().getLogger().log(Level.WARNING, "Could not activate " + activations[n], e);
                }
                ++n;
            }
        }
    }

    public void deactivate() {
        if (this.isActivated()) {
            int n = this.m_currentActivated.size() - 1;
            while (n >= 0) {
                AbstractSiteActivator a = this.m_currentActivated.get(n);
                try {
                    a.deactivate();
                }
                catch (Exception e) {
                    CorePlugin.getDefault().getLogger().log(Level.WARNING, "Could not deactivate " + a, e);
                }
                --n;
            }
            this.setDeactivated();
        }
    }

    private void setDeactivated() {
        this.m_currentActivated = null;
    }

    public void registerActivator(AbstractSiteActivator activator) {
        activator.initialize(this);
        if (this.isActivated()) {
            this.m_currentActivated.add(activator);
            activator.activate();
        }
        this.m_activators.add(activator);
    }

    public void unregisterActivator(AbstractSiteActivator activator) {
        if (this.isActivated()) {
            if (this.m_currentActivated.contains(activator)) {
                activator.deactivate();
            }
            this.m_currentActivated.remove(activator);
        }
        if (this.m_activators.removeElement(activator)) {
            activator.dispose();
        }
    }

    public void dispose() {
        if (this.isActivated()) {
            this.deactivate();
        }
        Object[] activations = this.m_activators.toArray();
        int n = 0;
        while (n < activations.length) {
            ((AbstractSiteActivator)activations[n]).dispose();
            ++n;
        }
        this.m_activators.clear();
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider provider) {
        String id;
        String string = id = menuManager.getId() != null ? menuManager.getId() : this.getId();
        if (this.m_parentSite instanceof IEditorSite) {
            ((IEditorSite)this.m_parentSite).registerContextMenu(id, menuManager, provider, false);
        } else {
            this.m_parentSite.registerContextMenu(id, menuManager, provider);
        }
    }

    public IMenuService getMenuService() {
        return (IMenuService)this.m_parentSite.getService(IMenuService.class);
    }

    public ICommandService getCommandService() {
        return (ICommandService)this.m_parentSite.getService(ICommandService.class);
    }

    public IHandlerService getHandlerService() {
        return (IHandlerService)this.m_parentSite.getService(IHandlerService.class);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.m_selectionActivator.setSelectionProvider(provider);
    }

    @Override
    public <T> T getService(Class<T> api) {
        return this.m_registry.getService(api);
    }

    public boolean hasService(Class api) {
        return this.m_registry.hasService(api);
    }

    @Override
    public <T> boolean registerService(Class<T> api, T serviceInstance) {
        return this.m_registry.registerService(api, serviceInstance);
    }

    @Override
    public IServiceRegistry getParent() {
        return this.m_registry.getParent();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.m_parentSite.getWorkbenchWindow();
    }

    public void setIdentifier(String identifier) {
        this.m_id = identifier;
    }
}

