/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.sections;

import com.jrockit.mc.core.handlers.MCContextMenuManager;
import com.jrockit.mc.core.sections.MCClientSectionPart;
import com.jrockit.mc.core.site.SiteFocusListener;
import com.jrockit.mc.core.ui.MCLayoutFactory;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ViewerSectionPart
extends MCClientSectionPart {
    private MenuManager m_menuManager;
    protected Viewer m_viewer;

    public ViewerSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected abstract Viewer createViewer(Composite var1);

    protected Composite createViewerClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        Composite container = formToolkit.createComposite(section, 0);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout(1));
        this.m_viewer = this.createViewer(container);
        this.m_viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        return container;
    }

    public Viewer getViewer() {
        return this.m_viewer;
    }

    protected final Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        Composite viewerClient = this.createViewerClient(form, formToolkit, section);
        this.setupFocousListeners();
        this.setupSelectionProvider();
        this.setupContextMenu();
        this.setupSelectionListeners();
        return viewerClient;
    }

    protected void setupFocousListeners() {
        this.getViewer().getControl().addFocusListener((FocusListener)new SiteFocusListener(this.getSite()));
    }

    protected void setupSelectionListeners() {
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ViewerSectionPart.this.getManagedForm().fireSelectionChanged((IFormPart)ViewerSectionPart.this, event.getSelectionProvider().getSelection());
            }
        });
    }

    protected void setupSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    protected void setupContextMenu() {
        MenuManager menuManager = this.getMenuManager();
        if (menuManager != null) {
            Control control = this.getViewer().getControl();
            Menu menu = menuManager.createContextMenu(control);
            control.setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.getViewer());
        }
    }

    protected MenuManager getMenuManager() {
        if (this.m_menuManager == null) {
            this.m_menuManager = new MCContextMenuManager(this.getSectionIdentifier());
        }
        return this.m_menuManager;
    }

    public void setFocus() {
        if (this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().setFocus();
        }
    }
}

