/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.sections;

import com.jrockit.mc.core.sections.MCSectionPart;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class TextSectionPart
extends MCSectionPart {
    protected Text m_text;
    private int m_heightHint;

    public TextSectionPart(Composite parent, FormToolkit toolkit, int style, int heightHint, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
        this.m_heightHint = heightHint;
    }

    public abstract void initializeSection(Section var1);

    public abstract void initializeText(Text var1);

    public Text getText() {
        return this.m_text;
    }

    public void setText(String textString) {
        Text text = this.getText();
        if (text != null && !text.isDisposed()) {
            text.setText(textString);
            String t = text.getText();
            text.setSelection(t.length(), t.length());
        }
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.initializeSection(this.getSection());
        ScrolledForm scrolledForm = this.createScrolledForm(form, form.getToolkit(), (Composite)this.getSection());
        this.getSection().setClient((Control)scrolledForm);
        form.getToolkit().paintBordersFor(scrolledForm.getBody());
    }

    protected ScrolledForm createScrolledForm(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        TableWrapLayout layout = new TableWrapLayout();
        TableWrapData wrapData = new TableWrapData(256, 256);
        wrapData.heightHint = this.m_heightHint;
        this.createText(toolkit, form.getBody());
        this.initializeText(this.getText());
        this.getText().setLayoutData((Object)wrapData);
        form.getBody().setLayout((Layout)layout);
        return form;
    }

    protected void createText(FormToolkit toolkit, Composite container) {
        this.m_text = toolkit.createText(container, "", 578);
    }

    public void saveDialogSettings(IDialogSettings settings) {
    }

    public void loadDialogSettings(IDialogSettings settings) {
    }
}

