/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.sections;

import com.jrockit.mc.core.sections.MCClientSectionPart;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class TabSectionPart
extends MCClientSectionPart {
    private final String DATA_IDENTIFIER = "tab.section.part";
    private CTabFolder m_tabFolder;

    public TabSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        final ScrolledComposite sc = new ScrolledComposite(section, 512);
        formToolkit.adapt((Composite)sc);
        this.m_tabFolder = new CTabFolder((Composite)sc, 0);
        formToolkit.adapt((Composite)this.m_tabFolder);
        this.m_tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabItem item = (CTabItem)event.item;
                SectionPart part = (SectionPart)item.getData("tab.section.part");
                if (part instanceof ITabPartListener) {
                    ((ITabPartListener)part).changedTabSelection();
                }
            }
        });
        this.initTabFolder(this.m_tabFolder);
        this.m_tabFolder.setSelection(0);
        sc.setContent((Control)this.m_tabFolder);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = sc.getClientArea();
                sc.setMinSize(TabSectionPart.this.m_tabFolder.computeSize(r.width, -1));
            }
        });
        return sc;
    }

    protected abstract void initTabFolder(CTabFolder var1);

    public void addTabSection(SectionPart sectionPart, String title) {
        CTabFolder folder = this.getTabFolder();
        assert (folder != null);
        assert (title != null);
        assert (sectionPart != null);
        if (folder != null && title != null && sectionPart != null) {
            this.getManagedForm().addPart((IFormPart)sectionPart);
            this.getManagedForm().refresh();
            CTabItem tabItem = new CTabItem(folder, 0);
            tabItem.setData("tab.section.part", (Object)sectionPart);
            tabItem.setControl((Control)sectionPart.getSection());
            tabItem.setText(title);
        }
    }

    private CTabFolder getTabFolder() {
        return this.m_tabFolder;
    }

    public void loadDialogSettings(IDialogSettings settings) {
    }

    public void saveDialogSettings(IDialogSettings settings) {
    }

    public static interface ITabPartListener {
        public void changedTabSelection();
    }
}

