/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.sections;

import com.jrockit.mc.core.HorizontalAction;
import com.jrockit.mc.core.VerticalAction;
import com.jrockit.mc.core.sections.MCSectionPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class MCSashSection
extends MCSectionPart
implements IPropertyChangeListener {
    private SashForm m_sashForm;
    private boolean m_useFormToolbar = true;
    private HorizontalAction m_hAction;
    private VerticalAction m_vAction;

    public MCSashSection(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    protected abstract void addSashParts(IManagedForm var1, Composite var2);

    public void initialize(IManagedForm managedForm) {
        super.initialize(managedForm);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 50;
        gd.heightHint = 50;
        this.m_sashForm = new SashForm(managedForm.getForm().getBody(), 256);
        managedForm.getToolkit().adapt((Composite)this.m_sashForm);
        this.addSashParts(managedForm, (Composite)this.m_sashForm);
        this.createToolBarActions(managedForm);
        managedForm.getForm().getBody().setLayout((Layout)layout);
        this.m_sashForm.setLayoutData((Object)gd);
    }

    public void useFormToolbar(boolean useFormToolbar) {
        this.m_useFormToolbar = useFormToolbar;
    }

    public void setOrientation(int orientation) {
        this.m_sashForm.setOrientation(orientation);
    }

    public void setWeights(int[] weights) {
        this.m_sashForm.setWeights(weights);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("PROPERTY_ORIENTATION_CHANGE".equals(event.getProperty())) {
            this.onOrientationChange(this.m_sashForm.getOrientation());
        }
    }

    protected void onOrientationChange(int orientation) {
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        boolean horizontal = this.m_sashForm.getOrientation() == 256;
        this.m_hAction = new HorizontalAction(managedForm, this.m_sashForm, horizontal);
        this.m_hAction.addPropertyChangeListener(this);
        this.m_vAction = new VerticalAction(managedForm, this.m_sashForm, !horizontal);
        this.m_vAction.addPropertyChangeListener(this);
        if (this.m_useFormToolbar) {
            managedForm.getForm().getToolBarManager().add((IAction)this.m_hAction);
            managedForm.getForm().getToolBarManager().add((IAction)this.m_vAction);
            managedForm.getForm().updateToolBar();
        } else {
            this.getMCToolBarManager().add((IAction)this.m_hAction);
            this.getMCToolBarManager().add((IAction)this.m_vAction);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.m_hAction != null) {
            this.m_hAction.removePropertyChangeListener(this);
        }
        if (this.m_vAction != null) {
            this.m_vAction.removePropertyChangeListener(this);
        }
    }
}

