/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.preferences;

import com.jrockit.mc.common.security.SecurityException;
import com.jrockit.mc.common.security.SecurityManagerFactory;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.preferences.Messages;
import java.util.logging.Level;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MissionControlPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public MissionControlPage() {
        super(1);
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.MissionControlPage_DESCRIPTION);
    }

    public void createFieldEditors() {
        if (CorePlugin.getDefault().getIDESupport().supportsLoggerConfiguration()) {
            this.addField((FieldEditor)new FileFieldEditor("loggingSettingsFile", Messages.MissionControlPage_CAPTION_LOGGING_FILE, this.getFieldEditorParent()));
        }
        this.addField((FieldEditor)new BooleanFieldEditor("graphics.antialiasing", Messages.MissionControlPage_CAPTION_USE_ANTI_ALIASING, this.getFieldEditorParent()));
        this.createAccessibilityOptionsGroup(this.getFieldEditorParent());
        this.createResetPasswordButton();
    }

    private void createResetPasswordButton() {
        Button b = new Button(this.getFieldEditorParent(), 0);
        b.setText(Messages.MissionControlPage_BUTTON_RESET_MASTER_PASSWORD);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MissionControlPage.this.showConfirmPasswordReset();
            }
        });
    }

    private void showConfirmPasswordReset() {
        MessageBox messageBox = new MessageBox(this.getShell(), 200);
        messageBox.setMessage(Messages.MissionControlPage_DIALOG_MESSAGE_RESET_MASTER_PASSWORD);
        messageBox.setText(Messages.MissionControlPage_DIALOG_TITLE_RESET_MASTER_PASSWORD);
        int response = messageBox.open();
        if (response == 64) {
            try {
                SecurityManagerFactory.getSecurityManager().setMasterPassword(null);
            }
            catch (SecurityException e) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not change the master password!", e);
            }
        }
    }

    private void createAccessibilityOptionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData groupGridData = new GridData(4, 0x1000000, true, false);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setText(Messages.MissionControlPage_ACCESSIBILITY_OPTIONS_GROUP_TEXT);
        this.addField((FieldEditor)new BooleanFieldEditor("accessibility.mode", Messages.MissionControlPage_ACCESSIBILITY_MODE_TEXT, this.createIndentedComposite((Composite)group, 0, 0)));
        this.addField((FieldEditor)new BooleanFieldEditor("accessibility.buttonsAsText", Messages.MissionControlPage_ACCESSIBILITY_BUTTONS_AS_TEXT_TEXT, this.createIndentedComposite((Composite)group, 20, 0)));
        this.createNoteComposite(this.getFont(), (Composite)group, Messages.MissionControlPage_NOTE_HEADER, Messages.MissionControlPage_HELP_NOTE_TEXT);
    }

    private Composite createIndentedComposite(Composite parent, int horizontalIndent, int verticalIndent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = horizontalIndent;
        gridData.verticalIndent = verticalIndent;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }
}

