/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.NumberField;
import java.text.NumberFormat;

public class TimeSpanField
extends NumberField {
    protected static final String DAYS_HOURS_SEPARATOR = " d ";
    protected static final String HOURS_MINUTES_SEPARATOR = " h ";
    protected static final String MINUTES_SECONDS_SEPARATOR = " m ";
    protected static final String SECONDS_MILLIS_SEPARATOR = " s ";
    protected static final String END_MILLIS_SEPARATOR = " ";
    protected static final String NO_TIME_SPAN = "0 s";
    protected static final String MICROS_END = " \u00b5s";
    public static final String SECOND_END = " s";
    protected static final int SECONDS_PER_MINUTE = 60;
    protected static final int MINUTES_PER_HOUR = 60;
    protected static final int HOURS_PER_DAY = 24;
    protected static final int MILLIS_PER_SECOND = 1000;
    protected static NumberFormat noFractions = NumberFormat.getNumberInstance();
    protected static NumberFormat integerTwoDigit = NumberFormat.getNumberInstance();
    protected static NumberFormat integerThreeDigit = NumberFormat.getNumberInstance();
    protected static NumberFormat secondsFormat;
    protected static NumberFormat millisHighPrecisionFormat;
    protected static NumberFormat millisFractionFormat;
    private int m_digits;

    static {
        millisFractionFormat = NumberFormat.getInstance();
        noFractions.setMaximumFractionDigits(0);
        integerTwoDigit.setMinimumIntegerDigits(2);
        integerTwoDigit.setMaximumIntegerDigits(2);
        integerTwoDigit.setMaximumFractionDigits(0);
        integerThreeDigit.setMinimumIntegerDigits(3);
        integerThreeDigit.setMaximumIntegerDigits(3);
        integerThreeDigit.setMaximumFractionDigits(0);
        secondsFormat = NumberFormat.getInstance();
        secondsFormat.setMaximumFractionDigits(3);
        secondsFormat.setMinimumFractionDigits(3);
        millisFractionFormat.setMaximumFractionDigits(3);
        millisFractionFormat.setMinimumFractionDigits(3);
        millisHighPrecisionFormat = NumberFormat.getInstance();
        millisHighPrecisionFormat.setMaximumFractionDigits(9);
        millisHighPrecisionFormat.setMinimumFractionDigits(0);
    }

    public TimeSpanField(int id) {
        this(id, 3);
    }

    public TimeSpanField(int id, int digits) {
        super(id);
        this.m_digits = digits;
    }

    public String formatObject(Object object) {
        if (object instanceof Number) {
            Number time = (Number)object;
            if (!TimeSpanField.isValid(time)) {
                return super.formatObject(null);
            }
            return this.formatTimeSpan(time);
        }
        return super.formatObject(object);
    }

    private String formatTimeSpan(Number number) {
        long total_days;
        if (number.doubleValue() == 0.0) {
            return NO_TIME_SPAN;
        }
        long total_millis = Math.abs(number.longValue());
        long total_seconds = total_millis / 1000L;
        long total_minutes = total_seconds / 60L;
        long total_hours = total_minutes / 60L;
        long days = total_days = total_hours / 24L;
        long hours = total_hours - total_days * 24L;
        long minutes = total_minutes - total_hours * 60L;
        long seconds = total_seconds - total_minutes * 60L;
        long millis = total_millis - total_seconds * 1000L;
        double d = number.doubleValue();
        double fractionMillis = Math.abs(d) - (double)(total_seconds * 1000L);
        String timeSpan = String.valueOf(number.doubleValue() < 0.0 ? "-" : "") + this.formatTimeSpan(days, hours, minutes, seconds);
        if (fractionMillis == 0.0) {
            return timeSpan.trim();
        }
        if (number instanceof Double) {
            if (fractionMillis < 1.0) {
                return String.valueOf(timeSpan) + millisFractionFormat.format(fractionMillis * 1000.0) + MICROS_END;
            }
            return String.valueOf(timeSpan) + millisFractionFormat.format(fractionMillis) + END_MILLIS_SEPARATOR + this.getUnit();
        }
        if (total_seconds > 0L) {
            return String.valueOf(timeSpan) + integerThreeDigit.format(millis) + END_MILLIS_SEPARATOR + this.getUnit();
        }
        return String.valueOf(noFractions.format(number)) + END_MILLIS_SEPARATOR + this.getUnit();
    }

    public String formatTimeSpan(long days, long hours, long minutes, long seconds) {
        if (days > 0L) {
            return String.valueOf(noFractions.format(days)) + DAYS_HOURS_SEPARATOR + integerTwoDigit.format(hours) + HOURS_MINUTES_SEPARATOR + integerTwoDigit.format(minutes) + MINUTES_SECONDS_SEPARATOR + integerTwoDigit.format(seconds) + SECONDS_MILLIS_SEPARATOR;
        }
        if (hours > 0L) {
            return String.valueOf(noFractions.format(hours)) + HOURS_MINUTES_SEPARATOR + integerTwoDigit.format(minutes) + MINUTES_SECONDS_SEPARATOR + integerTwoDigit.format(seconds) + SECONDS_MILLIS_SEPARATOR;
        }
        if (minutes > 0L) {
            return String.valueOf(noFractions.format(minutes)) + MINUTES_SECONDS_SEPARATOR + integerTwoDigit.format(seconds) + SECONDS_MILLIS_SEPARATOR;
        }
        if (seconds > 0L) {
            return String.valueOf(noFractions.format(seconds)) + SECONDS_MILLIS_SEPARATOR;
        }
        return "";
    }

    public static String formatSeconds(Number millis) {
        return secondsFormat.format(new Double(millis.doubleValue() / 1000.0));
    }

    public String formatForClipboard(Object object) {
        if (object instanceof Number && TimeSpanField.isValid((Number)object)) {
            if (object instanceof Double) {
                return NumberField.formatNumberForClipboardWithPrecision((Number)object, 9);
            }
            return NumberField.formatNumberForClipboardWithPrecision((Number)object, this.m_digits);
        }
        return super.formatForClipboard(null);
    }

    public String getUnit() {
        return "ms";
    }

    public String getTooltip(Object object) {
        if (object instanceof Number && TimeSpanField.isValid((Number)object)) {
            return String.valueOf(millisFractionFormat.format(((Number)object).doubleValue() / 1000.0)) + SECOND_END;
        }
        return null;
    }
}

