/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.NumberField;
import java.text.DateFormat;

public class TimeField
extends NumberField {
    private static final String MILLIS = "ms";
    private static final String SECOND_MILLIS_SEPARATOR = " ";
    private static DateFormat m_dateFormat = DateFormat.getDateTimeInstance(3, 2);

    public TimeField(int id) {
        super(id);
    }

    public String formatObject(Object object) {
        if (object instanceof Number && TimeField.isValid((Number)object)) {
            String s = m_dateFormat.format((Number)object);
            if (this.getShowMillis()) {
                s = String.valueOf(s) + SECOND_MILLIS_SEPARATOR + TimeField.zeroPad(((Number)object).longValue() % 1000L) + MILLIS;
            }
            return s;
        }
        return super.formatObject(object);
    }

    public boolean getShowMillis() {
        return this.getBoolean("showMillis", true);
    }

    public void setShowMillis(boolean show) {
        this.setProperty("showMillis", new Boolean(show).toString());
    }

    private static String zeroPad(long value) {
        if (value < 10L) {
            return "00" + Long.toString(value);
        }
        if (value < 100L) {
            return "0" + Long.toString(value);
        }
        return Long.toString(value);
    }

    public String formatForClipboard(Object object) {
        return this.formatObject(object);
    }
}

