/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.Messages;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.model.fields.TimeSpanField;
import java.text.MessageFormat;

public class TicksFields
extends Field {
    private final TimeSpanField TIME_SPAN_FIELD = new TimeSpanField(0);
    private final NumberField NUMBER_FIELD = new NumberField(0);
    private double m_tickPerSecond = Double.NaN;

    public TicksFields(int id) {
        super(id);
    }

    public String formatObject(Object object) {
        if (object instanceof Number) {
            if (this.m_tickPerSecond == Double.NEGATIVE_INFINITY || Double.isNaN(this.m_tickPerSecond)) {
                return MessageFormat.format(Messages.TicksFields_TICKS_UNIT_X_TEXT, object);
            }
            double d = 1000.0 * ((Number)object).doubleValue() / this.m_tickPerSecond;
            return this.TIME_SPAN_FIELD.formatObject(new Double(d));
        }
        return TicksFields.defaultFormat(null);
    }

    public String formatForClipboard(Object object) {
        if (object instanceof Number) {
            if (this.m_tickPerSecond == Double.NEGATIVE_INFINITY || Double.isNaN(this.m_tickPerSecond)) {
                return this.NUMBER_FIELD.formatForClipboard(object);
            }
            double d = 1000.0 * ((Number)object).doubleValue() / this.m_tickPerSecond;
            return this.TIME_SPAN_FIELD.formatForClipboard(new Double(d));
        }
        return TicksFields.defaultFormat(null);
    }

    public void setTickPerSecond(double ticksPerSecond) {
        this.m_tickPerSecond = ticksPerSecond;
    }

    public double getTicksPerSecond() {
        return this.m_tickPerSecond;
    }
}

