/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IStructuredRowSelection;
import com.jrockit.mc.core.model.fields.Row;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class StructuredRowSelection
implements IStructuredSelection,
IStructuredRowSelection {
    private final StructuredSelection m_selection;
    private final StructuredSelection m_rowSelection;
    private final Field[] m_fields;

    public StructuredRowSelection(Row[] rowElements, Field[] fields) {
        this.m_rowSelection = new StructuredSelection((Object[])rowElements);
        Object[] elements = new Object[rowElements.length];
        int n = 0;
        while (n < rowElements.length) {
            elements[n] = rowElements[n].getElement();
            ++n;
        }
        this.m_selection = new StructuredSelection(elements);
        this.m_fields = fields;
    }

    public StructuredRowSelection(Row rowElement, Field[] fields) {
        this(new Row[]{rowElement}, fields);
    }

    public StructuredRowSelection(List rowElements, Field[] fields) {
        this(rowElements.toArray(new Row[rowElements.size()]), fields);
    }

    public Object getFirstElement() {
        return this.m_selection.getFirstElement();
    }

    public Iterator iterator() {
        return this.m_selection.iterator();
    }

    public Object[] toArray() {
        return this.m_selection.toArray();
    }

    public List toList() {
        return this.m_selection.toList();
    }

    public Row getFirstRowElement() {
        return (Row)this.m_rowSelection.getFirstElement();
    }

    public Iterator rowIterator() {
        return this.m_rowSelection.iterator();
    }

    public Object[] toRowArray() {
        return this.m_rowSelection.toArray();
    }

    public List toRowList() {
        return this.m_rowSelection.toList();
    }

    public int size() {
        return this.m_selection.size();
    }

    public boolean isEmpty() {
        return this.m_selection.isEmpty();
    }

    public boolean equals(Object o) {
        return this.m_rowSelection.equals(o);
    }

    public String toString() {
        return this.isEmpty() ? JFaceResources.getString((String)"<empty_selection>") : this.m_selection.toList().toString();
    }

    public Field[] getFields() {
        return this.m_fields;
    }
}

