/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.IRowTreeSelection;
import com.jrockit.mc.core.model.fields.Row;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

public class RowTreeSelection
implements IRowTreeSelection {
    private final TreeSelection m_treeSelection;
    private final TreeSelection m_rowTreeSelection;
    private final Field[] m_fields;

    public RowTreeSelection(TreePath[] rowPaths, IElementComparer comparer, Field[] fields) {
        this.m_treeSelection = new TreeSelection(RowTreeSelection.createRowFreePaths(rowPaths), comparer);
        this.m_rowTreeSelection = new TreeSelection(rowPaths, comparer);
        this.m_fields = fields;
    }

    static TreePath[] createRowFreePaths(TreePath[] rowPaths) {
        TreePath[] path = new TreePath[rowPaths.length];
        int n = 0;
        while (n < rowPaths.length) {
            path[n] = new TreePath(RowTreeSelection.createRowFreeSegment(rowPaths[n]));
            ++n;
        }
        return path;
    }

    private static Object[] createRowFreeSegment(TreePath treePath) {
        Object[] segments = new Object[treePath.getSegmentCount()];
        int count = treePath.getSegmentCount();
        int n = 0;
        while (n < count) {
            segments[n] = ((Row)treePath.getSegment(n)).getElement();
            ++n;
        }
        return segments;
    }

    public TreePath[] getPaths() {
        return this.m_treeSelection.getPaths();
    }

    public TreePath[] getPathsFor(Object element) {
        return this.m_treeSelection.getPathsFor(element);
    }

    public Object getFirstElement() {
        return this.m_treeSelection.getFirstElement();
    }

    public Iterator iterator() {
        return this.m_treeSelection.iterator();
    }

    public int size() {
        return this.m_treeSelection.size();
    }

    public Object[] toArray() {
        return this.m_treeSelection.toArray();
    }

    public List toList() {
        return this.m_treeSelection.toList();
    }

    public boolean isEmpty() {
        return this.m_treeSelection.isEmpty();
    }

    public Field[] getFields() {
        return this.m_fields;
    }

    public Row getFirstRowElement() {
        return (Row)this.m_rowTreeSelection.getFirstElement();
    }

    public Iterator rowIterator() {
        return this.m_rowTreeSelection.iterator();
    }

    public Object[] toRowArray() {
        return (Row[])this.m_rowTreeSelection.toArray();
    }

    public List toRowList() {
        return this.m_rowTreeSelection.toList();
    }

    public TreePath[] getRowPaths() {
        return this.m_rowTreeSelection.getPaths();
    }

    public TreePath[] getRowPathsFor(Object element) {
        return this.m_rowTreeSelection.getPathsFor(element);
    }
}

