/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.NumberField;
import java.text.NumberFormat;

public class PercentageField
extends NumberField {
    private final NumberFormat m_percantageFormat = NumberFormat.getPercentInstance();

    public PercentageField(int id) {
        this(id, 2);
    }

    public PercentageField(int id, int accuracy) {
        super(id);
        this.m_percantageFormat.setMinimumFractionDigits(accuracy);
        this.m_percantageFormat.setMaximumFractionDigits(accuracy);
    }

    public String formatObject(Object object) {
        if (object instanceof Number && PercentageField.isValid((Number)object)) {
            return this.m_percantageFormat.format(((Number)object).doubleValue());
        }
        return Field.defaultFormat(null);
    }

    public String formatForClipboard(Object object) {
        if (object instanceof Number) {
            return NumberField.formatNumberForClipboard(new Double(100.0 * ((Number)object).doubleValue()));
        }
        return Field.defaultFormat(null);
    }

    public String getUnit() {
        return "%";
    }
}

