/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.Field;
import java.text.NumberFormat;

public class NumberField
extends Field {
    private static NumberFormat m_numberFormat = NumberFormat.getInstance();
    private static NumberFormat m_numberHighPrecision = NumberFormat.getInstance();

    public NumberField(int id) {
        super(id);
    }

    public static boolean isValid(Number number) {
        if (number instanceof Integer) {
            return number.intValue() != Integer.MIN_VALUE;
        }
        if (number instanceof Long) {
            return number.longValue() != Long.MIN_VALUE;
        }
        if (number instanceof Double) {
            return !NumberField.isPatchedNanosNA(number.doubleValue()) && !Double.isNaN(number.doubleValue()) && number.doubleValue() != Double.NEGATIVE_INFINITY;
        }
        if (number instanceof Float) {
            return !Float.isNaN(number.floatValue()) && number.floatValue() != Float.NEGATIVE_INFINITY;
        }
        return true;
    }

    private static boolean isPatchedNanosNA(double doubleValue) {
        return doubleValue == -9.223372036854775E12;
    }

    public static String formatNumber(Number number) {
        if (NumberField.isValid(number)) {
            return m_numberFormat.format(number);
        }
        return NumberField.defaultFormat(null);
    }

    protected static String removeNonBreakingSpace(String s) {
        return s.replace('\u00a0', ' ');
    }

    public static String formatNumberForClipboard(Number number) {
        return NumberField.removeNonBreakingSpace(NumberField.formatNumber(number));
    }

    public static String formatNumberForClipboardWithPrecision(Number value, int fractionDigits) {
        if (NumberField.isValid(value)) {
            m_numberHighPrecision.setMaximumFractionDigits(fractionDigits);
            m_numberHighPrecision.setMinimumFractionDigits(fractionDigits);
            return NumberField.removeNonBreakingSpace(m_numberHighPrecision.format(value));
        }
        return NumberField.defaultFormat(null);
    }

    public void setTimeBased(boolean derivative) {
        this.setBoolean("timeBased", derivative);
    }

    public boolean getTimeBased() {
        return this.getBoolean("timeBased", false);
    }

    protected String getTimeUnit(String unit) {
        return this.getTimeBased() ? String.valueOf(unit) + "/s" : unit;
    }

    public String formatObject(Object object) {
        if (object instanceof Number) {
            return NumberField.formatNumber((Number)object);
        }
        return super.formatObject(object);
    }

    public String formatForClipboard(Object object) {
        if (object instanceof Number) {
            return NumberField.formatNumberForClipboard((Number)object);
        }
        return super.formatObject(object);
    }
}

