/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.NumberField;
import java.text.NumberFormat;

public class NormalizedScientificNotationField
extends NumberField {
    private NumberFormat format = NumberFormat.getNumberInstance();

    public NormalizedScientificNotationField(int id, int precision) {
        super(id);
        this.setInteger("precision", precision);
    }

    protected int getPrecision() {
        return this.getInteger("precision", 2);
    }

    public String formatObject(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int exp = NormalizedScientificNotationField.calculateExponential(d);
            return String.valueOf(this.formatCoefficient(d, exp, this.getPrecision())) + "\u00d710E" + exp;
        }
        return super.formatObject(object);
    }

    public String getTooltip(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int exp = NormalizedScientificNotationField.calculateExponential(d);
            return String.valueOf(this.formatCoefficient(d, exp, this.getPrecision())) + "\u00d710E" + exp;
        }
        return super.getTooltip(object);
    }

    private String formatCoefficient(double d, int exp, int precision) {
        this.format.setMinimumFractionDigits(precision);
        this.format.setMaximumFractionDigits(precision);
        double v = d / Math.pow(10.0, exp);
        return this.format.format(v);
    }

    public static String formatExponential2(int exp) {
        if (exp < 0) {
            return "\u207b" + NormalizedScientificNotationField.formatExponential2(-exp);
        }
        if (exp > 0) {
            return String.valueOf(NormalizedScientificNotationField.formatExponential2(exp / 10)) + NormalizedScientificNotationField.formatSuperscriptCharacter(exp % 10);
        }
        return "";
    }

    private static String formatSuperscriptCharacter(int value) {
        if (value == 0) {
            return "\u2070";
        }
        if (value == 1) {
            return "\u00b9";
        }
        if (value == 2) {
            return "\u00b2";
        }
        if (value == 3) {
            return "\u00b3";
        }
        if (value == 4) {
            return "\u2074";
        }
        if (value == 5) {
            return "\u2075";
        }
        if (value == 6) {
            return "\u2076";
        }
        if (value == 7) {
            return "\u2077";
        }
        if (value == 8) {
            return "\u2078";
        }
        if (value == 9) {
            return "\u2079";
        }
        throw new IllegalArgumentException("Out of range" + value);
    }

    public static int calculateExponential(double d) {
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            return 0;
        }
        return d == 0.0 ? 0 : (d < 1.0 ? NormalizedScientificNotationField.calculateNegativeExponent(Math.abs(d)) : NormalizedScientificNotationField.calculatePostiveExponent(Math.abs(d)));
    }

    private static int calculatePostiveExponent(double d) {
        return d >= 10.0 ? 1 + NormalizedScientificNotationField.calculatePostiveExponent(d / 10.0) : 0;
    }

    private static int calculateNegativeExponent(double d) {
        return d < 1.0 ? NormalizedScientificNotationField.calculateNegativeExponent(d * 10.0) - 1 : 0;
    }
}

